/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.simplelootviewer.common.impl.data;

import com.google.common.collect.ArrayListMultimap;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.common.api.loot.LootPoolEntryDescriptions;
import net.darkhax.bookshelf.common.impl.Constants;
import net.darkhax.simplelootviewer.common.impl.SimpleLootViewer;
import net.darkhax.simplelootviewer.common.impl.config.Config;
import net.darkhax.simplelootviewer.common.impl.data.LootType;
import net.darkhax.simplelootviewer.common.impl.data.info.Name;
import net.darkhax.simplelootviewer.common.impl.data.info.NameType;
import net.darkhax.simplelootviewer.common.impl.data.info.TableInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;

public record LootTableHelper() {
    private static final DecimalFormat FORMAT = new DecimalFormat("#.##");
    private static int CACHE_VERSION = -1;
    private static ArrayListMultimap<LootType, TableInfo> CACHE;

    public static ArrayListMultimap<LootType, TableInfo> getCachedData(RegistryAccess registries) {
        if (CACHE == null || CACHE_VERSION != Constants.SERVER_REVISION) {
            SimpleLootViewer.LOG.info("Rebuilding table cache.");
            CACHE = LootTableHelper.collectData(registries);
            CACHE_VERSION = Constants.SERVER_REVISION;
        }
        return CACHE;
    }

    public static ArrayListMultimap<LootType, TableInfo> collectData(RegistryAccess registries) {
        long start = System.nanoTime();
        ArrayListMultimap info = ArrayListMultimap.create();
        Registry lootTableRegistry = registries.registry(Registries.LOOT_TABLE).orElse(null);
        if (lootTableRegistry != null) {
            ArrayListMultimap BLOCK_DROPS = ArrayListMultimap.create();
            for (Map.Entry block : BuiltInRegistries.BLOCK.entrySet()) {
                BLOCK_DROPS.put((Object)((Block)block.getValue()).getLootTable().location(), (Object)((ResourceKey)block.getKey()).location());
            }
            ArrayListMultimap ENTITY_DROPS = ArrayListMultimap.create();
            for (Map.Entry type : BuiltInRegistries.ENTITY_TYPE.entrySet()) {
                ENTITY_DROPS.put((Object)((EntityType)type.getValue()).getDefaultLootTable().location(), (Object)((ResourceKey)type.getKey()).location());
            }
            for (Map.Entry entry : lootTableRegistry.entrySet()) {
                LootType lootType;
                ResourceLocation tableKey = ((ResourceKey)entry.getKey()).location();
                if (((List)((Config)SimpleLootViewer.CONFIG.get()).hidden.get()).contains(tableKey) || !(lootType = LootType.determineType(tableKey)).isEnabled()) continue;
                Name name = LootTableHelper.nameTable(tableKey, (ArrayListMultimap<ResourceLocation, ResourceLocation>)BLOCK_DROPS, (ArrayListMultimap<ResourceLocation, ResourceLocation>)ENTITY_DROPS);
                info.put((Object)lootType, (Object)new TableInfo(tableKey, name, LootPoolEntryDescriptions.getUniqueItems((RegistryAccess)registries, (LootTable)((LootTable)entry.getValue()))));
            }
        } else {
            SimpleLootViewer.LOG.warn("Unable to load loot tables from registry.");
        }
        long end = System.nanoTime();
        SimpleLootViewer.LOG.info("Processed {} loot tables in {}ms", (Object)info.size(), (Object)FORMAT.format((double)(end - start) / 1000000.0));
        return info;
    }

    public static Name nameTable(ResourceLocation tableKey, ArrayListMultimap<ResourceLocation, ResourceLocation> blockTables, ArrayListMultimap<ResourceLocation, ResourceLocation> entityTables) {
        if (blockTables.containsKey((Object)tableKey)) {
            return new Name(NameType.BLOCK, blockTables.get((Object)tableKey).toArray(ResourceLocation[]::new));
        }
        if (entityTables.containsKey((Object)tableKey)) {
            return new Name(NameType.ENTITY, entityTables.get((Object)tableKey).toArray(ResourceLocation[]::new));
        }
        return new Name(NameType.TABLE, tableKey);
    }

    public static Component nameTableFromId(ResourceLocation tableKey) {
        return Component.translatableWithFallback((String)("table." + tableKey.getNamespace() + "." + tableKey.getPath().replaceAll("/", ".") + ".name"), (String)tableKey.toString());
    }
}

