/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.simplelootviewer.common.impl.data;

import com.google.common.collect.ArrayListMultimap;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.common.api.loot.LootPoolEntryDescriptions;
import net.darkhax.bookshelf.common.impl.Constants;
import net.darkhax.simplelootviewer.common.impl.SimpleLootViewer;
import net.darkhax.simplelootviewer.common.impl.config.Config;
import net.darkhax.simplelootviewer.common.impl.data.LootType;
import net.darkhax.simplelootviewer.common.impl.data.info.Name;
import net.darkhax.simplelootviewer.common.impl.data.info.NameType;
import net.darkhax.simplelootviewer.common.impl.data.info.TableInfo;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public record LootTableHelper() {
    private static final DecimalFormat FORMAT = new DecimalFormat("#.##");
    private static int CACHE_VERSION = -1;
    private static ArrayListMultimap<LootType, TableInfo> CACHE;

    public static ArrayListMultimap<LootType, TableInfo> getCachedData(class_5455 registries) {
        if (CACHE == null || CACHE_VERSION != Constants.SERVER_REVISION) {
            SimpleLootViewer.LOG.info("Rebuilding table cache.");
            CACHE = LootTableHelper.collectData(registries);
            CACHE_VERSION = Constants.SERVER_REVISION;
        }
        return CACHE;
    }

    public static ArrayListMultimap<LootType, TableInfo> collectData(class_5455 registries) {
        long start = System.nanoTime();
        ArrayListMultimap info = ArrayListMultimap.create();
        class_2378 lootTableRegistry = registries.method_33310(class_7924.field_50079).orElse(null);
        if (lootTableRegistry != null) {
            ArrayListMultimap BLOCK_DROPS = ArrayListMultimap.create();
            for (Map.Entry block : class_7923.field_41175.method_29722()) {
                BLOCK_DROPS.put((Object)((class_2248)block.getValue()).method_26162().method_29177(), (Object)((class_5321)block.getKey()).method_29177());
            }
            ArrayListMultimap ENTITY_DROPS = ArrayListMultimap.create();
            for (Map.Entry type : class_7923.field_41177.method_29722()) {
                ENTITY_DROPS.put((Object)((class_1299)type.getValue()).method_16351().method_29177(), (Object)((class_5321)type.getKey()).method_29177());
            }
            for (Map.Entry entry : lootTableRegistry.method_29722()) {
                LootType lootType;
                class_2960 tableKey = ((class_5321)entry.getKey()).method_29177();
                if (((List)((Config)SimpleLootViewer.CONFIG.get()).hidden.get()).contains(tableKey) || !(lootType = LootType.determineType(tableKey)).isEnabled()) continue;
                Name name = LootTableHelper.nameTable(tableKey, (ArrayListMultimap<class_2960, class_2960>)BLOCK_DROPS, (ArrayListMultimap<class_2960, class_2960>)ENTITY_DROPS);
                info.put((Object)lootType, (Object)new TableInfo(tableKey, name, LootPoolEntryDescriptions.getUniqueItems((class_5455)registries, (class_52)((class_52)entry.getValue()))));
            }
        } else {
            SimpleLootViewer.LOG.warn("Unable to load loot tables from registry.");
        }
        long end = System.nanoTime();
        SimpleLootViewer.LOG.info("Processed {} loot tables in {}ms", (Object)info.size(), (Object)FORMAT.format((double)(end - start) / 1000000.0));
        return info;
    }

    public static Name nameTable(class_2960 tableKey, ArrayListMultimap<class_2960, class_2960> blockTables, ArrayListMultimap<class_2960, class_2960> entityTables) {
        if (blockTables.containsKey((Object)tableKey)) {
            return new Name(NameType.BLOCK, blockTables.get((Object)tableKey).toArray(class_2960[]::new));
        }
        if (entityTables.containsKey((Object)tableKey)) {
            return new Name(NameType.ENTITY, entityTables.get((Object)tableKey).toArray(class_2960[]::new));
        }
        return new Name(NameType.TABLE, tableKey);
    }

    public static class_2561 nameTableFromId(class_2960 tableKey) {
        return class_2561.method_48321((String)("table." + tableKey.method_12836() + "." + tableKey.method_12832().replaceAll("/", ".") + ".name"), (String)tableKey.toString());
    }
}

