/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.simplelootviewer.common.impl.jei;

import java.util.function.Function;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.darkhax.bookshelf.common.api.function.CachedSupplier;
import net.darkhax.simplelootviewer.common.impl.data.LootType;
import net.darkhax.simplelootviewer.common.impl.data.info.TableInfo;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LootCategory
implements IRecipeCategory<TableInfo> {
    private final RecipeType<TableInfo> type;
    private final IGuiHelper guiHelper;
    private final class_2561 title;
    private final CachedSupplier<IDrawable> icon;
    private final IDrawableStatic background;

    public LootCategory(RecipeType<TableInfo> recipeType, LootType type, IGuiHelper guiHelper) {
        this(recipeType, guiHelper, (IGuiHelper g) -> g.createDrawableItemLike((class_1935)type.icon.get()));
    }

    public LootCategory(RecipeType<TableInfo> type, IGuiHelper guiHelper, Function<IGuiHelper, IDrawable> icon) {
        this.type = type;
        this.guiHelper = guiHelper;
        this.title = class_2561.method_43471((String)("gui.jei.category." + type.getUid().method_12836() + "." + type.getUid().method_12832() + ".name"));
        this.icon = CachedSupplier.cache(() -> (IDrawable)icon.apply(this.guiHelper));
        this.background = guiHelper.createBlankDrawable(182, 67);
    }

    @NotNull
    public RecipeType<TableInfo> getRecipeType() {
        return this.type;
    }

    @NotNull
    public class_2561 getTitle() {
        return this.title;
    }

    public int getWidth() {
        return 182;
    }

    public int getHeight() {
        return 67;
    }

    @Nullable
    public IDrawable getIcon() {
        return (IDrawable)this.icon.get();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull TableInfo recipe, @NotNull IFocusGroup focuses) {
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 3; ++y) {
                int slotIndex = y * 10 + x;
                IRecipeSlotBuilder dropSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 2 + x * 18, 12 + y * 18);
                if (slotIndex >= recipe.items().size()) continue;
                dropSlot.addItemStack(recipe.items().get(slotIndex));
                dropSlot.addRichTooltipCallback((view, tooltip) -> {
                    if (class_310.method_1551().field_1690.field_1827) {
                        tooltip.add((class_5348)class_2561.method_43470((String)recipe.lootTable().toString()).method_27692(class_124.field_1080));
                    }
                });
            }
        }
    }

    public void draw(@NotNull TableInfo recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull class_332 graphics, double mouseX, double mouseY) {
        this.background.draw(graphics);
        graphics.method_51433(class_310.method_1551().field_1772, LootCategory.loopingString(recipe.name().name().getString(), 34), 2, 0, 0x555555, false);
        IDrawableStatic slot = this.guiHelper.getSlotDrawable();
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 3; ++y) {
                slot.draw(graphics, 1 + x * 18, 11 + y * 18);
            }
        }
    }

    public static String loopingString(String input, int maxLength) {
        if (((String)input).length() <= maxLength) {
            return input;
        }
        input = (String)input + "    ";
        int startIndex = Math.abs((int)(class_156.method_658() / 1000L)) % ((String)input).length();
        StringBuilder result = new StringBuilder(maxLength);
        for (int outputIndex = 0; outputIndex < maxLength; ++outputIndex) {
            int inputIndex = (startIndex + outputIndex) % ((String)input).length();
            result.append(((String)input).charAt(inputIndex));
        }
        return result.toString();
    }
}

