package archives.tater.gentlyholds;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3902;
import net.minecraft.class_5712;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

import static net.minecraft.class_3532.method_15338;

public class EntityItem extends class_1792 {

    public static final String[] REMOVE_TAGS = {
            class_1297.field_29994,
            "Pos",
            "Rotation",
            "Motion",
            "FallDistance",
            "Fire",
            "Air",
            "OnGround",
            "HurtByTimestamp",
            "Invulnerable",
            "PortalCooldown",
            "TicksFrozen",
            "Glowing",
            "HurtTime",
            "SleepingX",
            "SleepingY",
            "SleepingZ"
    };

    private static final MapCodec<class_1299<?>> ENTITY_TYPE_MAP_CODEC = class_7923.field_41177.method_39673().fieldOf("id");

    public EntityItem(class_1793 settings) {
        super(settings.method_7889(1));
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        var world = context.method_8045();
        if (!(world instanceof class_3218 serverWorld)) return class_1269.field_5812;

        var stack = context.method_8041();
        var pos = context.method_8037();
        var direction = context.method_8038();
        var state = world.method_8320(pos);

        var targetPos = state.method_26220(world, pos).method_1110() ? pos : pos.method_10093(direction);

        var entityType = getEntityType(stack.method_57824(class_9334.field_49609));

        if (entityType == null) return class_1269.field_21466;

        if (stack.method_57826(GentlyHolds.UNINITIALIZED)) {
            if (entityType.method_5894(
                    serverWorld,
                    stack,
                    context.method_8036(),
                    targetPos,
                    class_3730.field_16465,
                    true,
                    pos != targetPos && direction == class_2350.field_11036
            ) == null) return class_1269.field_21466;
        } else {
            var nbt = stack.method_57824(class_9334.field_49609);
            if (nbt == null) return class_1269.field_5814;
            var entity = class_1299.method_5892(nbt.method_57461(), world).orElse(null);
            if (entity == null) return class_1269.field_21466;
            entity.method_5808(targetPos.method_10263() + 0.5, targetPos.method_10264(), targetPos.method_10260() + 0.5, method_15393(world.field_9229.method_43057() * 360), 0f);
            if (entity instanceof class_1308 mobEntity) {
                mobEntity.field_6241 = mobEntity.method_36454();
                mobEntity.field_6283 = mobEntity.method_36454();
                mobEntity.method_5966();
            }
            world.method_8649(entity);
        }

        stack.method_7934(1);
        world.method_33596(context.method_8036(), class_5712.field_28738, pos);

        return class_1269.field_21466;
    }

    @Override
    public class_2561 method_7864(class_1799 stack) {
        var type = getEntityType(stack.method_57824(class_9334.field_49609));
        return type == null ? super.method_7864(stack) : type.method_5897();
    }

    public static @Nullable class_1299<?> getEntityType(@Nullable class_9279 nbt) {
        return nbt == null || nbt.method_57458() ? null : nbt.method_57446(ENTITY_TYPE_MAP_CODEC).result().orElse(null);
    }

    public static class_1799 from(class_1297 entity) {
        var nbt = new class_2487();
        if (!entity.method_5786(nbt)) return class_1799.field_8037;
        for (String key : REMOVE_TAGS) {
            nbt.method_10551(key);
        }
        var stack = GentlyHolds.ENTITY_ITEM.method_7854();
        class_9279.method_57453(class_9334.field_49609, stack, nbt);
        if (entity.method_16914())
            stack.method_57379(class_9334.field_49631, entity.method_5797());
        return stack;
    }

    public static class_1799 fromType(class_1299<?> entityType) {
        var stack = GentlyHolds.ENTITY_ITEM.method_7854();
        var entityTag = new class_2487();
        entityTag.method_10582(class_1297.field_29985, class_7923.field_41177.method_10221(entityType).toString());
        class_9279.method_57453(class_9334.field_49609, stack, entityTag);
        stack.method_57379(GentlyHolds.UNINITIALIZED, class_3902.field_17274);
        return stack;
    }

    public static @Nullable class_1297 entityOf(class_1799 stack, class_1937 world) {
        var entityData = stack.method_57824(class_9334.field_49609);
        if (entityData == null) return null;
        return entityOf(entityData, world);
    }

    public static @Nullable class_1297 entityOf(class_9279 entityData, class_1937 world) {
        return class_1299.method_5892(entityData.method_57461(), world).orElse(null);
    }
}
