package archives.tater.gentlyholds;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.minecraft.class_310;
import net.minecraft.class_7833;
import net.minecraft.class_811;

public class GentlyHoldsClient implements ClientModInitializer {
	@Override
	public void onInitializeClient() {
		// This entrypoint is suitable for setting up client-specific logic, such as rendering.
		BuiltinItemRendererRegistry.INSTANCE.register(GentlyHolds.ENTITY_ITEM, (stack, mode, matrices, vertexConsumers, light, overlay) -> {
			var entity = EntityCache.get(stack, class_310.method_1551().field_1687);
			if (entity == null) return;
			var camera = class_310.method_1551().method_1560();
			if (camera != null)
				entity.field_6012 = camera.field_6012;
			var rotated = mode == class_811.field_4319 && entity.method_17681() >= entity.method_17682();
			var centered = !rotated && mode == class_811.field_4319 || mode == class_811.field_4317;
			matrices.method_22903();
            matrices.method_22904(0.5, rotated || centered ? 0.5 : 0.0, 0.5);
			if (rotated) {
				matrices.method_22907(class_7833.field_40714.rotationDegrees(90));
				matrices.method_22907(class_7833.field_40716.rotationDegrees(180));
			}
			if (mode != class_811.field_4316) {
				var scale = 1 / Math.max(1, Math.max(entity.method_17681(), entity.method_17682()));
				matrices.method_22905(scale, scale, scale);
			}
			if (centered)
				matrices.method_46416(0, -entity.method_17682() / 2, 0);
			if (rotated)
				matrices.method_22904(0, -1 / 16.0, 0);
			class_310.method_1551().method_1561().method_3954(entity, 0.0, 0.0, 0.0, 0f, camera == null ? 0 : class_310.method_1551().method_60646().method_60637(false), matrices, vertexConsumers, light);
			matrices.method_22909();
		});
	}
}
