package archives.tater.gentlyholds.mixin;

import archives.tater.gentlyholds.EntityItem;
import archives.tater.gentlyholds.GentlyHolds;
import archives.tater.gentlyholds.GentlyHoldsConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static net.minecraft.class_3532.method_15349;

@Mixin(class_1542.class)
public abstract class ItemEntityMixin extends class_1297 {
    public ItemEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Shadow
    public abstract class_1799 getStack();

    @Shadow
    private int itemAge;

    @Inject(
            method = "tick",
            at = @At("HEAD"),
            cancellable = true
    )
    private void spawnEntity(CallbackInfo ci) {
        if (method_37908().field_9236 || itemAge != 0) return;
        var stack = getStack();
        if (!GentlyHoldsConfig.spawnDrop || !stack.method_31574(GentlyHolds.ENTITY_ITEM)) return;
        var entity = EntityItem.entityOf(stack, method_37908());
        if (entity == null) return;
        var velocity = method_18798();
        var yaw = method_15349(velocity.field_1351, velocity.field_1352);
        entity.method_5808(method_23317(), method_23318(), method_23321(), Double.isNaN(yaw) ? 0f : (float) yaw, 0f);
        entity.method_18799(velocity);
        method_37908().method_8649(entity);
        method_31472();
        ci.cancel();
    }
}
