package archives.tater.gentlyholds;

import com.mojang.serialization.MapCodec;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10515;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_898;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

import java.util.Set;

public class EntityItemModelRenderer implements class_10515<class_9279> {

    private final class_898 entityRenderDispatcher;

    public EntityItemModelRenderer(class_898 entityRenderDispatcher) {
        this.entityRenderDispatcher = entityRenderDispatcher;
    }

    @Override
    public void render(@Nullable class_9279 data, class_811 displayContext, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, boolean glint) {
        var entity = EntityCache.get(data, class_310.method_1551().field_1687);
        if (entity == null) return;
        var camera = class_310.method_1551().method_1560();
        if (camera != null)
            entity.field_6012 = camera.field_6012;
        var rotated = displayContext == class_811.field_4319 && entity.method_17681() >= entity.method_17682();
        var centered = !rotated && displayContext == class_811.field_4319 || displayContext == class_811.field_4317;
        matrices.method_22903();
        matrices.method_22904(0.5, rotated || centered ? 0.5 : 0.0, 0.5);
        if (rotated) {
            matrices.method_22907(class_7833.field_40714.rotationDegrees(90));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(180));
        }
        if (displayContext != class_811.field_4316) {
            var scale = 1 / Math.max(1, Math.max(entity.method_17681(), entity.method_17682()));
            matrices.method_22905(scale, scale, scale);
        }
        if (centered)
            matrices.method_46416(0, -entity.method_17682() / 2, 0);
        if (rotated)
            matrices.method_22904(0, -1 / 16.0, 0);
        entityRenderDispatcher.method_62424(entity, 0.0, 0.0, 0.0, camera == null ? 0 : class_310.method_1551().method_61966().method_60637(false), matrices, vertexConsumers, light);
        matrices.method_22909();
    }

    @Override
    public void method_72175(Set<Vector3f> vertices) {

    }

    @Override
    public @Nullable class_9279 method_65695(class_1799 stack) {
        return stack.method_58694(class_9334.field_49609);
    }

    @Environment(EnvType.CLIENT)
    public record Unbaked() implements class_10515.class_10516 {
        public static final MapCodec<EntityItemModelRenderer.Unbaked> CODEC = MapCodec.unit(new EntityItemModelRenderer.Unbaked());

        @Override
        public MapCodec<EntityItemModelRenderer.Unbaked> method_65696() {
            return CODEC;
        }

        @Override
        public class_10515<?> method_65698(class_5599 entityModels) {
            return new EntityItemModelRenderer(class_310.method_1551().method_1561());
        }
    }
}
