package archives.tater.gentlyholds;

import eu.midnightdust.lib.config.MidnightConfig;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.item.v1.DefaultItemComponentEvents;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalEntityTypeTags;
import net.minecraft.class_10192;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1311;
import net.minecraft.class_1508;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3902;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.stream.StreamSupport;

public class GentlyHolds implements ModInitializer {
	public static final String MOD_ID = "gentlyholds";

	// This logger is used to write text to the console and the log file.
	// It is considered best practice to use your mod id as the logger's name.
	// That way, it's clear which mod wrote info, warnings, and errors.
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

	public static class_2960 id(String path) {
		return class_2960.method_60655(MOD_ID, path);
	}

	public static final class_9331<class_3902> UNINITIALIZED = class_2378.method_10230(
			class_7923.field_49658,
			id("uninitialized"),
			class_9331.<class_3902>method_57873().method_57881(class_3902.field_51563).method_57882(class_9139.method_56431(class_3902.field_17274)).method_57880()
	);

	public static final class_6862<class_1299<?>> MISC_LIVING = class_6862.method_40092(class_7924.field_41266, id("misc_living"));

	public static final class_1792 ENTITY_ITEM = class_1802.method_51348(
			class_5321.method_29179(class_7924.field_41197, id("entity_item")),
			EntityItem::new,
			new class_1792.class_1793()
	);

	public static final class_1761 ENTITIES = class_2378.method_10230(
			class_7923.field_44687,
			id("entities"),
			FabricItemGroup.builder()
					.method_47321(class_2561.method_43471("itemGroup." + MOD_ID + ".entities"))
					.method_47320(() -> EntityItem.fromType(class_1299.field_6046))
					.method_47317((displayContext, entries) -> {
						if (!GentlyHoldsConfig.itemGroup) return;
						var spawnEggTypes = StreamSupport.stream(class_1826.method_8017().spliterator(), false).map(spawnEggItem -> spawnEggItem.method_8015(displayContext.comp_1253(), ENTITY_ITEM.method_7854())).toList();
						class_7923.field_41177.forEach(entityType -> {
							if (entityType.method_5893() && entityType.method_5891() != class_1311.field_17715 && !entityType.method_20210(ConventionalEntityTypeTags.BOSSES) && (spawnEggTypes.contains(entityType) || entityType.method_20210(MISC_LIVING)))
								entries.method_45420(EntityItem.fromType(entityType));
						});
					})
					.method_47324()
	);

	public static boolean canPickup(class_1657 player, class_1297 target) {
		return target.method_17681() <= GentlyHoldsConfig.maxWidth && target.method_17682() <= GentlyHoldsConfig.maxHeight && GentlyHoldsConfig.entityRestriction.canPickup(player, target);
	}

	@Override
	public void onInitialize() {
		// This code runs as soon as Minecraft is in a mod-load-ready state.
		// However, some things (like resources) may still be uninitialized.
		// Proceed with mild caution.
		MidnightConfig.init(MOD_ID, GentlyHoldsConfig.class);

		if (GentlyHoldsConfig.canWearHat)
			DefaultItemComponentEvents.MODIFY.register(context -> {
				context.modify(ENTITY_ITEM, builder -> builder.method_57840(
						class_9334.field_54196,
						class_10192.method_64202(class_1304.field_6169).method_64209(false).method_64203()
				));
			});

		UseEntityCallback.EVENT.register((playerEntity, world, hand, entity, entityHitResult) -> {
			if (!playerEntity.method_21823()) return class_1269.field_5811;
			if (entity instanceof class_1657) return class_1269.field_5811;
			if (GentlyHoldsConfig.emptyHands && (!playerEntity.method_6047().method_7960() || !playerEntity.method_6079().method_7960())) return class_1269.field_5811;
			var targetEntity = entity instanceof class_1508 part ? part.field_7007 : entity;
			if (!canPickup(playerEntity, targetEntity)) return class_1269.field_5811;
			if (!(world instanceof class_3218 serverWorld)) return class_1269.field_5812;

			var stack = EntityItem.from(targetEntity);
			if (playerEntity.method_5998(hand).method_7960())
				playerEntity.method_6122(hand, stack);
			else if (!playerEntity.method_7270(stack))
				playerEntity.method_5775(serverWorld, stack);
			targetEntity.method_5650(class_1297.class_5529.field_27000);
			return class_1269.field_5812;
		});
	}
}
