package archives.tater.gentlyholds;

import eu.midnightdust.lib.config.MidnightConfig;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalEntityTypeTags;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1421;
import net.minecraft.class_1429;
import net.minecraft.class_1480;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_4140;
import net.minecraft.class_6025;
import org.jetbrains.annotations.Nullable;

public class GentlyHoldsConfig extends MidnightConfig {
    @Entry
    public static EntityRestriction entityRestriction = EntityRestriction.ANIMAL;
    @Entry(min = 0)
    public static float maxWidth = 2;
    @Entry(min = 0)
    public static float maxHeight = 2;
    @Entry
    public static boolean emptyHands = true;
    @Entry
    public static boolean spawnDrop = true;
    @Entry
    public static boolean canWearHat = true;
    @Entry
    public static boolean itemGroup = true;

    @SuppressWarnings("unused")
    public enum EntityRestriction {
        ANY { public boolean canPickup(class_1657 player, class_1297 target) {
            return true;
        } },
        LIVING { public boolean canPickup(class_1657 player, class_1297 target) {
            return target.method_5709();
        } },
        NON_BOSS { public boolean canPickup(class_1657 player, class_1297 target) {
            return target.method_5709() && !target.method_5864().method_20210(ConventionalEntityTypeTags.BOSSES);
        } },
        NON_MONSTER { public boolean canPickup(class_1657 player, class_1297 target) {
            return target.method_5709() && !(target instanceof class_1569);
        } },
        NOT_AGGROED { public boolean canPickup(class_1657 player, class_1297 target) {
            return target.method_5709() && !target.method_5864().method_20210(ConventionalEntityTypeTags.BOSSES) && (!(target instanceof class_1308 mobEntity) || getTarget(mobEntity) == null);
        } },
        NOT_AGGROED_PLAYER { public boolean canPickup(class_1657 player, class_1297 target) {
            return target.method_5709() && !target.method_5864().method_20210(ConventionalEntityTypeTags.BOSSES) && (!(target instanceof class_1308 mobEntity) || getTarget(mobEntity) != player);
        } },
        ANIMAL { public boolean canPickup(class_1657 player, class_1297 target) {
            return target instanceof class_1429 || target instanceof class_1480 || target instanceof class_1421;
        } },
        OWNED { public boolean canPickup(class_1657 player, class_1297 target) {
            return target instanceof class_6025 tameable && tameable.method_35057() == player;
        } };

        public abstract boolean canPickup(class_1657 player, class_1297 target);

        private static @Nullable class_1309 getTarget(class_1308 mobEntity) {
            var target = mobEntity.method_5968();
            if (target != null)
                return target.method_5805() ? target : null;
            var targetOptional = mobEntity.method_18868().method_46873(class_4140.field_22355);
            //noinspection OptionalAssignedToNull
            if (targetOptional == null || targetOptional.isEmpty()) return null;
            var targetActual = targetOptional.get();
            return targetActual.method_5805() ? targetActual : null;
        }
    }
}
