package archives.tater.gentlyholds.mixin;

import archives.tater.gentlyholds.EntityItem;
import archives.tater.gentlyholds.GentlyHolds;
import archives.tater.gentlyholds.GentlyHoldsConfig;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1542.class)
public abstract class ItemEntityMixin {
	@Shadow public abstract void setStack(class_1799 stack);

	@Inject(method = "<init>(Lnet/minecraft/world/World;DDDLnet/minecraft/item/ItemStack;DDD)V", at = @At("TAIL"))
	private void init(class_1937 world, double x, double y, double z, class_1799 stack, double velocityX, double velocityY, double velocityZ, CallbackInfo ci) {
        if (!GentlyHoldsConfig.spawnDrop || !stack.method_31574(GentlyHolds.ENTITY_ITEM)) return;
        var entity = EntityItem.entityOf(stack, world);
		if (entity == null) return;
		entity.method_5808(x, y, z, 0f, 0f);
		entity.method_18800(8 * velocityX, velocityY, 8 * velocityZ);
        world.method_8649(entity);
        setStack(class_1799.field_8037);
    }
}
