/*
 * Decompiled with CFR 0.152.
 */
package net.atobaazul.scguns_cnc.common.entity;

import com.mrcrayfish.framework.network.message.IMessage;
import com.teamabnormals.caverns_and_chasms.common.item.silver.SilverItem;
import com.teamabnormals.caverns_and_chasms.core.registry.CCParticleTypes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import top.ribs.scguns.Config;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.init.ModDamageTypes;
import top.ribs.scguns.init.ModTags;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageBlood;
import top.ribs.scguns.network.message.S2CMessageProjectileHitEntity;
import top.ribs.scguns.util.GunEnchantmentHelper;
import top.ribs.scguns.util.GunModifierHelper;

public class HexRoundProjectileEntity
extends ProjectileEntity {
    private static final float ADVANCED_SHIELD_DISABLE_CHANCE = 0.45f;
    private static final float HEADSHOT_EFFECT_DURATION_MULTIPLIER = 1.25f;

    public HexRoundProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public HexRoundProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
    }

    float getCriticalDamage(ItemStack weapon, RandomSource rand, float damage) {
        float chance = GunModifierHelper.getCriticalChance((ItemStack)weapon);
        if (rand.m_188501_() < chance) {
            float critMultiplier = this.modifiedGun.getGeneral().getCritDamageMultiplier();
            return damage * critMultiplier;
        }
        return damage;
    }

    protected void onProjectileTick() {
        if (this.m_9236_().f_46443_ && this.f_19797_ > 1 && this.f_19797_ < this.life) {
            this.m_9236_().m_6493_((ParticleOptions)CCParticleTypes.SILVER_SPARK.get(), true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        boolean blocked;
        boolean wasAlive;
        float newDamage;
        float damage = this.getDamage();
        boolean critical = damage != (newDamage = this.getCriticalDamage(this.getWeapon(), this.f_19796_, damage));
        damage = newDamage;
        ResourceLocation advantage = this.getProjectile().getAdvantage();
        damage *= this.advantageMultiplier(entity);
        boolean bl = wasAlive = entity instanceof LivingEntity && entity.m_6084_();
        if (headshot) {
            damage = (float)((double)damage * (Double)Config.COMMON.gameplay.headShotDamageMultiplier.get());
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)entity;
            damage = GunEnchantmentHelper.getPuncturingDamageReduction((ItemStack)this.getWeapon(), (LivingEntity)livingTarget, (float)damage);
            damage = this.applyProjectileProtection(livingTarget, damage);
            damage = this.calculateArmorBypassDamage(livingTarget, damage);
        }
        if (!(blocked = ProjectileEntity.ProjectileHelper.handleShieldHit((Entity)entity, (Entity)this, (float)damage, (float)0.45f))) {
            DamageSource source = ModDamageTypes.Sources.projectile((RegistryAccess)this.m_9236_().m_9598_(), (ProjectileEntity)this, (LivingEntity)((LivingEntity)this.getOwner()));
            if (!entity.m_6095_().m_204039_(ModTags.Entities.GHOST) || advantage.equals((Object)ModTags.Entities.UNDEAD.f_203868_())) {
                entity.m_6469_(source, damage / 2.0f);
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    entity.f_19802_ = 0;
                    entity.m_6469_(entity.m_269291_().m_269425_(), damage / 2.0f);
                    SilverItem.causeMagicDamageParticles((LivingEntity)livingEntity);
                    ResourceLocation effectLocation = this.getProjectile().getImpactEffect();
                    if (effectLocation != null) {
                        MobEffect effect;
                        float effectChance = this.getProjectile().getImpactEffectChance();
                        if (this.f_19796_.m_188501_() < effectChance && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation)) != null) {
                            int duration = this.getProjectile().getImpactEffectDuration();
                            if (headshot) {
                                duration = (int)((float)duration * 1.25f);
                            }
                            if (entity instanceof LivingEntity) {
                                LivingEntity livingTarget = (LivingEntity)entity;
                                damage = this.applyProjectileProtection(livingTarget, damage);
                                damage = this.calculateArmorBypassDamage(livingTarget, damage);
                            }
                            livingEntity.m_7292_(new MobEffectInstance(effect, duration, this.getProjectile().getImpactEffectAmplifier()));
                        }
                    }
                }
            }
            if (entity instanceof LivingEntity) {
                GunEnchantmentHelper.applyElementalPopEffect((ItemStack)this.getWeapon(), (LivingEntity)((LivingEntity)entity));
            }
        }
        if (this.shooter instanceof Player) {
            int hitType = critical ? 2 : (headshot ? 1 : 0);
            PacketHandler.getPlayChannel().sendToPlayer(() -> (ServerPlayer)this.shooter, (IMessage)new S2CMessageProjectileHitEntity(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, hitType, entity instanceof Player));
        }
        PacketHandler.getPlayChannel().sendToTracking(() -> entity, (IMessage)new S2CMessageBlood(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, entity.m_6095_()));
    }
}

