/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fleshcatcher.procedures;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.DimensionSpecialEffectsManager;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class LightProcedure {
    private static float skyLevel = 0.0f;
    private static float blockLevel = 0.0f;
    private static Vector3f skyColor = null;
    private static Vector3f blockColor = null;
    private static final Consumer<Object[]> CONSUMER = params -> {
        int pixelX = (Integer)params[5];
        int pixelY = (Integer)params[6];
        if (pixelX == 0 && pixelY == 0) {
            Minecraft minecraft = Minecraft.m_91087_();
            Entity entity = minecraft.f_91063_.m_109153_().m_90592_();
            if (entity != null) {
                ClientLevel level = minecraft.f_91073_;
                float partialTick = ((Float)params[1]).floatValue();
                Vec3 pos = entity.m_20318_(partialTick);
                LightProcedure.execute(null, (LevelAccessor)level, (ResourceKey<Level>)level.m_46472_(), partialTick);
            }
        }
        LightProcedure.calculateColor((Vector3f)params[7], pixelX, pixelY);
    };

    private static float calculateBaseLevel(float level) {
        return level * level * (level * -2.0f + 3.0f);
    }

    private static void calculateColor(Vector3f lightColor, int pixelX, int pixelY) {
        if (pixelX == pixelY) {
            return;
        }
        if (pixelX > pixelY) {
            if (blockColor == null) {
                return;
            }
            if (blockLevel == 0.0f) {
                return;
            }
            float level = Math.abs(LightProcedure.calculateBaseLevel((float)pixelX / 15.0f) - LightProcedure.calculateBaseLevel((float)pixelY / 15.0f)) * blockLevel;
            lightColor.set(Mth.m_14036_((float)Mth.m_14179_((float)level, (float)lightColor.x(), (float)blockColor.x()), (float)0.0f, (float)1.0f), Mth.m_14036_((float)Mth.m_14179_((float)level, (float)lightColor.y(), (float)blockColor.y()), (float)0.0f, (float)1.0f), Mth.m_14036_((float)Mth.m_14179_((float)level, (float)lightColor.z(), (float)blockColor.z()), (float)0.0f, (float)1.0f));
        } else {
            if (skyColor == null) {
                return;
            }
            if (skyLevel == 0.0f) {
                return;
            }
            float level = (float)Math.abs(pixelX - pixelY) / 15.0f * skyLevel;
            lightColor.set(Mth.m_14036_((float)Mth.m_14179_((float)level, (float)lightColor.x(), (float)skyColor.x()), (float)0.0f, (float)1.0f), Mth.m_14036_((float)Mth.m_14179_((float)level, (float)lightColor.y(), (float)skyColor.y()), (float)0.0f, (float)1.0f), Mth.m_14036_((float)Mth.m_14179_((float)level, (float)lightColor.z(), (float)skyColor.z()), (float)0.0f, (float)1.0f));
        }
    }

    public static void setBlockColor(int blockColor) {
        LightProcedure.setBlockColor(1.0f, blockColor);
    }

    public static void setBlockColor(float level, int blockColor) {
        blockLevel = Mth.m_14036_((float)level, (float)0.0f, (float)1.0f);
        LightProcedure.blockColor = new Vector3f((float)(blockColor >> 16 & 0xFF) / 255.0f, (float)(blockColor >> 8 & 0xFF) / 255.0f, (float)(blockColor & 0xFF) / 255.0f);
    }

    public static void setSkyColor(int skyColor) {
        LightProcedure.setSkyColor(1.0f, skyColor);
    }

    public static void setSkyColor(float level, int skyColor) {
        skyLevel = Mth.m_14036_((float)level, (float)0.0f, (float)1.0f);
        LightProcedure.skyColor = new Vector3f((float)(skyColor >> 16 & 0xFF) / 255.0f, (float)(skyColor >> 8 & 0xFF) / 255.0f, (float)(skyColor & 0xFF) / 255.0f);
    }

    @SubscribeEvent
    public static void lightColorSetup(FMLClientSetupEvent event) {
        try {
            Field field = DimensionSpecialEffectsManager.class.getDeclaredField("EFFECTS");
            field.setAccessible(true);
            for (DimensionSpecialEffects dimensionSpecialEffects : ((ImmutableMap)field.get(null)).values()) {
                Class<?> effects = dimensionSpecialEffects.getClass();
                ((Set)effects.getField("CUSTOM_LIGHTS").get(null)).add(CONSUMER);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void execute(LevelAccessor world, ResourceKey<Level> dimension, double partialTick) {
        LightProcedure.execute(null, world, dimension, partialTick);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, ResourceKey<Level> dimension, double partialTick) {
        if (dimension == null) {
            return;
        }
        double R = 0.0;
        double G = 0.0;
        double B = 0.0;
        if (dimension == ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("fleshcatcher:the_organism"))) {
            R = (double)((new Object(){

                public int get(LevelAccessor levelAccessor, float partialTick) {
                    if (levelAccessor instanceof ClientLevel) {
                        Vec3 color = ((ClientLevel)levelAccessor).m_171660_(Minecraft.m_91087_().f_91063_.m_109153_().m_90583_(), partialTick);
                        return 0xFF000000 | (int)(color.m_7096_() * 255.0) << 16 | (int)(color.m_7098_() * 255.0) << 8 | (int)(color.m_7094_() * 255.0);
                    }
                    return 0;
                }
            }.get(world, (float)partialTick) >> 16 & 0xFF) - 35) < 0.001 ? 0.0 : (double)((new Object(){

                public int get(LevelAccessor levelAccessor, float partialTick) {
                    if (levelAccessor instanceof ClientLevel) {
                        Vec3 color = ((ClientLevel)levelAccessor).m_171660_(Minecraft.m_91087_().f_91063_.m_109153_().m_90583_(), partialTick);
                        return 0xFF000000 | (int)(color.m_7096_() * 255.0) << 16 | (int)(color.m_7098_() * 255.0) << 8 | (int)(color.m_7094_() * 255.0);
                    }
                    return 0;
                }
            }.get(world, (float)partialTick) >> 16 & 0xFF) - 35);
            G = (double)((new Object(){

                public int get(LevelAccessor levelAccessor, float partialTick) {
                    if (levelAccessor instanceof ClientLevel) {
                        Vec3 color = ((ClientLevel)levelAccessor).m_171660_(Minecraft.m_91087_().f_91063_.m_109153_().m_90583_(), partialTick);
                        return 0xFF000000 | (int)(color.m_7096_() * 255.0) << 16 | (int)(color.m_7098_() * 255.0) << 8 | (int)(color.m_7094_() * 255.0);
                    }
                    return 0;
                }
            }.get(world, (float)partialTick) >> 8 & 0xFF) - 35) < 0.001 ? 0.0 : (double)((new Object(){

                public int get(LevelAccessor levelAccessor, float partialTick) {
                    if (levelAccessor instanceof ClientLevel) {
                        Vec3 color = ((ClientLevel)levelAccessor).m_171660_(Minecraft.m_91087_().f_91063_.m_109153_().m_90583_(), partialTick);
                        return 0xFF000000 | (int)(color.m_7096_() * 255.0) << 16 | (int)(color.m_7098_() * 255.0) << 8 | (int)(color.m_7094_() * 255.0);
                    }
                    return 0;
                }
            }.get(world, (float)partialTick) >> 8 & 0xFF) - 35);
            B = (double)((new Object(){

                public int get(LevelAccessor levelAccessor, float partialTick) {
                    if (levelAccessor instanceof ClientLevel) {
                        Vec3 color = ((ClientLevel)levelAccessor).m_171660_(Minecraft.m_91087_().f_91063_.m_109153_().m_90583_(), partialTick);
                        return 0xFF000000 | (int)(color.m_7096_() * 255.0) << 16 | (int)(color.m_7098_() * 255.0) << 8 | (int)(color.m_7094_() * 255.0);
                    }
                    return 0;
                }
            }.get(world, (float)partialTick) & 0xFF) - 35) < 0.001 ? 0.0 : (double)((new Object(){

                public int get(LevelAccessor levelAccessor, float partialTick) {
                    if (levelAccessor instanceof ClientLevel) {
                        Vec3 color = ((ClientLevel)levelAccessor).m_171660_(Minecraft.m_91087_().f_91063_.m_109153_().m_90583_(), partialTick);
                        return 0xFF000000 | (int)(color.m_7096_() * 255.0) << 16 | (int)(color.m_7098_() * 255.0) << 8 | (int)(color.m_7094_() * 255.0);
                    }
                    return 0;
                }
            }.get(world, (float)partialTick) & 0xFF) - 35);
            LightProcedure.setSkyColor(0xFF000000 | (int)R << 16 | (int)G << 8 | (int)B);
        }
    }
}

