/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fleshcatcher.init;

import java.util.Map;
import net.mcreator.fleshcatcher.FleshcatcherMod;
import net.mcreator.fleshcatcher.init.FleshcatcherModScreens;
import net.mcreator.fleshcatcher.network.MenuStateUpdateMessage;
import net.mcreator.fleshcatcher.world.inventory.ETGUIMenu;
import net.mcreator.fleshcatcher.world.inventory.GuideMenu;
import net.mcreator.fleshcatcher.world.inventory.LeaveBlockStationGuideMenu;
import net.mcreator.fleshcatcher.world.inventory.PincerContainerMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class FleshcatcherModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"fleshcatcher");
    public static final RegistryObject<MenuType<ETGUIMenu>> ETGUI = REGISTRY.register("etgui", () -> IForgeMenuType.create(ETGUIMenu::new));
    public static final RegistryObject<MenuType<PincerContainerMenu>> PINCER_CONTAINER = REGISTRY.register("pincer_container", () -> IForgeMenuType.create(PincerContainerMenu::new));
    public static final RegistryObject<MenuType<LeaveBlockStationGuideMenu>> LEAVE_BLOCK_STATION_GUIDE = REGISTRY.register("leave_block_station_guide", () -> IForgeMenuType.create(LeaveBlockStationGuideMenu::new));
    public static final RegistryObject<MenuType<GuideMenu>> GUIDE = REGISTRY.register("guide", () -> IForgeMenuType.create(GuideMenu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                FleshcatcherMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MenuStateUpdateMessage(elementType, name, elementState));
            } else if (player.m_9236_().f_46443_) {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof FleshcatcherModScreens.ScreenAccessor) {
                    FleshcatcherModScreens.ScreenAccessor accessor = (FleshcatcherModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                FleshcatcherMod.PACKET_HANDLER.sendToServer((Object)new MenuStateUpdateMessage(elementType, name, elementState));
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

