/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.unusualadventures.block;

import java.util.List;
import net.mcreator.unusualadventures.block.entity.ComputerBlockEntity;
import net.mcreator.unusualadventures.procedures.ComputerEmittedRedstonePowerProcedure;
import net.mcreator.unusualadventures.procedures.ComputerOnBlockRightClickedProcedure;
import net.mcreator.unusualadventures.procedures.ComputerTickUpdateProcedure;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ComputerBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<StateProperty> STATE = EnumProperty.create((String)"state", StateProperty.class);

    public ComputerBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.ANCIENT_DEBRIS).strength(1.0f, 10.0f).lightLevel(s -> 3).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(STATE, (Comparable)((Object)StateProperty.OFF))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)ComputerBlock.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)9.0, (double)9.0), (VoxelShape[])new VoxelShape[]{ComputerBlock.box((double)3.0, (double)0.0, (double)12.0, (double)13.0, (double)1.0, (double)15.0), ComputerBlock.box((double)2.0, (double)0.0, (double)9.0, (double)14.0, (double)10.0, (double)11.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)ComputerBlock.box((double)3.0, (double)0.0, (double)7.0, (double)13.0, (double)9.0, (double)15.0), (VoxelShape[])new VoxelShape[]{ComputerBlock.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)1.0, (double)4.0), ComputerBlock.box((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)10.0, (double)7.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)ComputerBlock.box((double)1.0, (double)0.0, (double)3.0, (double)9.0, (double)9.0, (double)13.0), (VoxelShape[])new VoxelShape[]{ComputerBlock.box((double)12.0, (double)0.0, (double)3.0, (double)15.0, (double)1.0, (double)13.0), ComputerBlock.box((double)9.0, (double)0.0, (double)2.0, (double)11.0, (double)10.0, (double)14.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)ComputerBlock.box((double)7.0, (double)0.0, (double)3.0, (double)15.0, (double)9.0, (double)13.0), (VoxelShape[])new VoxelShape[]{ComputerBlock.box((double)1.0, (double)0.0, (double)3.0, (double)4.0, (double)1.0, (double)13.0), ComputerBlock.box((double)5.0, (double)0.0, (double)2.0, (double)7.0, (double)10.0, (double)14.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, STATE, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue(STATE, (Comparable)((Object)StateProperty.OFF))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState blockstate, BlockGetter blockAccess, BlockPos pos, Direction direction) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        Level world = (Level)blockAccess;
        return (int)ComputerEmittedRedstonePowerProcedure.execute((LevelAccessor)world, x, y, z, blockstate);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        if (Screen.hasControlDown()) {
            list.add((Component)Component.translatable((String)"block.unusual_adventures.computer.description_0"));
            list.add((Component)Component.translatable((String)"block.unusual_adventures.computer.description_1"));
            list.add((Component)Component.translatable((String)"block.unusual_adventures.computer.description_2"));
        } else {
            list.add((Component)Component.translatable((String)"block.unusual_adventures.short_desc"));
        }
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        world.scheduleTick(pos, (Block)this, 4);
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        ComputerTickUpdateProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        world.scheduleTick(pos, (Block)this, 4);
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        InteractionResult result = ComputerOnBlockRightClickedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        return result;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ComputerBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(eventID, eventParam);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (state.hasProperty(STATE)) {
            String stateValue = ((StateProperty)((Object)state.getValue(STATE))).getSerializedName();
            if ("warning".equals(stateValue) || "coding".equals(stateValue)) {
                double offsetRange = 0.6;
                double x = (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * offsetRange;
                double y = (double)pos.getY() + 0.5 + (random.nextDouble() - 0.5) * offsetRange;
                double z = (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * offsetRange;
                level.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, x, y, z, 0.0, 0.0, 0.0);
            } else if ("music".equals(stateValue)) {
                double offsetRange = 0.4;
                double x = (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * offsetRange;
                double y = (double)pos.getY() + 0.8 + (random.nextDouble() - 0.5) * offsetRange;
                double z = (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * offsetRange;
                level.addParticle((ParticleOptions)ParticleTypes.NOTE, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof ComputerBlockEntity) {
                ComputerBlockEntity be = (ComputerBlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)be);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
                world.levelEvent(1011, pos, 0);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof ComputerBlockEntity) {
            ComputerBlockEntity be = (ComputerBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }

    public static enum StateProperty implements StringRepresentable
    {
        OFF("off"),
        LOGO("logo"),
        MESSAGE("message"),
        WARNING("warning"),
        CONSOLE("console"),
        CODING("coding"),
        BACKGROUND("background"),
        SCANNING("scanning"),
        MUSIC("music"),
        GAME("game");

        private final String name;

        private StateProperty(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

