/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.unusualadventures.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.mcreator.unusualadventures.ComputerCommandMessage;
import net.mcreator.unusualadventures.init.UnusualAdventuresModScreens;
import net.mcreator.unusualadventures.procedures.ConsoleAnswerProcedure;
import net.mcreator.unusualadventures.procedures.HelpCommandProcedure;
import net.mcreator.unusualadventures.world.inventory.ComputerMainScreenMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;

public class ComputerMainScreenScreen
extends AbstractContainerScreen<ComputerMainScreenMenu>
implements UnusualAdventuresModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    EditBox console;

    public ComputerMainScreenScreen(ComputerMainScreenMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 240;
        this.imageHeight = 160;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        if (elementType == 0 && elementState instanceof String) {
            String stringState = (String)elementState;
            if (name.equals("console")) {
                this.console.setValue(stringState);
            }
        }
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.console.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(ResourceLocation.parse((String)"unusual_adventures:textures/screens/console.png"), this.leftPos + 0, this.topPos + 0, 0.0f, 0.0f, 240, 160, 240, 160);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.console.isFocused()) {
            if (key == 257) {
                String commandText = this.console.getValue();
                PacketDistributor.sendToServer((CustomPacketPayload)new ComputerCommandMessage(commandText, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return true;
            }
            return this.console.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String consoleValue = this.console.getValue();
        super.resize(minecraft, width, height);
        this.console.setValue(consoleValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String[] lines0 = ConsoleAnswerProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z).split("\r?\n");
        int yOffset0 = 18;
        for (String line : lines0) {
            guiGraphics.drawString(this.font, line, 6, yOffset0, -14847448, false);
            Objects.requireNonNull(this.font);
            yOffset0 += 9;
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.unusual_adventures.console.available"), 5, 45, -15379939, false);
        String[] lines = HelpCommandProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z).split("\r?\n");
        Objects.requireNonNull(this.font);
        int yOffset = 47 + 9;
        for (String line : lines) {
            guiGraphics.drawString(this.font, line, 6, yOffset, -15379939, false);
            Objects.requireNonNull(this.font);
            yOffset += 9;
        }
    }

    public void init() {
        super.init();
        this.console = new EditBox(this.font, this.leftPos + 12, this.topPos + 6, 220, 18, (Component)Component.translatable((String)"gui.unusual_adventures.computer_main_screen.console"));
        this.console.setMaxLength(38);
        this.console.setBordered(false);
        this.console.setTextShadow(false);
        this.console.setTextColor(1929768);
        this.console.setFocused(true);
        this.console.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((ComputerMainScreenMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "console", content, false);
            }
        });
        this.console.setHint((Component)Component.translatable((String)"gui.unusual_adventures.computer_main_screen.console"));
        this.addWidget((GuiEventListener)this.console);
        this.setFocused((GuiEventListener)this.console);
    }
}

