/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.unusualadventures.item;

import java.util.List;
import net.mcreator.unusualadventures.procedures.NullGauntletEntitySwingsItemProcedure;
import net.mcreator.unusualadventures.procedures.NullGauntletLivingEntityIsHitWithItemProcedure;
import net.mcreator.unusualadventures.procedures.NullGauntletSpecialInformationProcedure;
import net.mcreator.unusualadventures.procedures.NullspaceDurabilityRegenProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class NullGauntletItem
extends Item {
    public NullGauntletItem() {
        super(new Item.Properties().durability(3000).rarity(Rarity.UNCOMMON));
    }

    public int getBarColor(ItemStack stack) {
        if (((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("state").equals("kb")) {
            return 0x7FFF00;
        }
        if (((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("state").equals("heal")) {
            return 16728000;
        }
        if (((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("state").equals("laser")) {
            return 0xFF9900;
        }
        if (((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("state").equals("dash")) {
            return 6074606;
        }
        return Mth.hsvToRgb((float)(Math.max(0.0f, 1.0f - (float)stack.getDamageValue() / (float)stack.getMaxDamage()) / 3.0f), (float)1.0f, (float)1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        Entity entity = itemstack.getEntityRepresentation() != null ? itemstack.getEntityRepresentation() : Minecraft.getInstance().player;
        String hoverText = NullGauntletSpecialInformationProcedure.execute(itemstack);
        if (hoverText != null) {
            for (String line : hoverText.split(",")) {
                list.add((Component)Component.literal((String)line));
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        NullGauntletEntitySwingsItemProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, (ItemStack)ar.getObject());
        return ar;
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        NullGauntletLivingEntityIsHitWithItemProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, (Entity)sourceentity, itemstack);
        return retval;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            NullspaceDurabilityRegenProcedure.execute(entity, itemstack);
        }
    }
}

