/*
 * Decompiled with CFR 0.152.
 */
package net.cloudygaming.betterheropackreloading;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.GZIPOutputStream;
import net.cloudygaming.betterheropackreloading.BetterHeroPackReloading;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class LogUtil {
    private static final File LOG_DIR = new File("logs/betterheropackreloading");
    private static final File LATEST_LOG = new File(LOG_DIR, "latest.log");

    private static void init() {
        if (!LOG_DIR.exists()) {
            LOG_DIR.mkdirs();
        }
        if (LATEST_LOG.exists()) {
            LogUtil.rotateLog();
        }
    }

    public static File getLatestLog() {
        return LATEST_LOG;
    }

    private static void rotateLog() {
        File archive;
        String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        int restart = 1;
        while (new File("logs/" + date + "-" + restart + ".log.gz").exists()) {
            ++restart;
        }
        --restart;
        int reload = 1;
        do {
            String suffix = reload == 1 ? "" : "-" + reload;
            archive = new File(LOG_DIR, date + "-" + restart + suffix + ".log.gz");
            ++reload;
        } while (archive.exists());
        try (BufferedReader reader = new BufferedReader(new FileReader(LATEST_LOG));
             GZIPOutputStream gos = new GZIPOutputStream(new FileOutputStream(archive));
             OutputStreamWriter osw = new OutputStreamWriter(gos);
             BufferedWriter writer = new BufferedWriter(osw);){
            String line;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.newLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LATEST_LOG.delete();
    }

    public static void log(String message) {
        LogUtil.log(message, false);
    }

    public static void log(String message, boolean sendToChat) {
        if (sendToChat) {
            LogUtil.sendMessage(message);
        }
        message = message.replaceAll("&[a-zA-Z1-9]", "");
        message = message.replaceAll("\u00a7[a-zA-Z1-9]", "");
        BetterHeroPackReloading.LOGGER.info(message);
        try {
            if (!LATEST_LOG.exists()) {
                LATEST_LOG.createNewFile();
            }
            try (FileWriter fw = new FileWriter(LATEST_LOG, true);
                 BufferedWriter bw = new BufferedWriter(fw);){
                String timestamp = new SimpleDateFormat("HH:mm:ss").format(new Date());
                bw.write("[" + timestamp + "] " + message);
                bw.newLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendMessage(String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        message = message.replace("&", "\u00a7");
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        ChatComponentText fullComponent = new ChatComponentText("");
        ChatStyle currentStyle = new ChatStyle().func_150238_a(EnumChatFormatting.WHITE);
        StringBuilder segment = new StringBuilder();
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (c == '\u00a7' && i + 1 < message.length()) {
                char code;
                EnumChatFormatting format;
                if (segment.length() > 0) {
                    ChatComponentText part = new ChatComponentText(segment.toString());
                    part.func_150255_a(currentStyle.func_150232_l());
                    fullComponent.func_150257_a((IChatComponent)part);
                    segment.setLength(0);
                }
                if ((format = LogUtil.getByCode(code = message.charAt(++i))) == null) continue;
                if (format == EnumChatFormatting.RESET) {
                    currentStyle = new ChatStyle().func_150238_a(EnumChatFormatting.WHITE);
                    continue;
                }
                if (format.func_96302_c()) {
                    currentStyle = new ChatStyle().func_150238_a(format);
                    continue;
                }
                ChatStyle newStyle = currentStyle.func_150232_l();
                switch (format) {
                    case BOLD: {
                        newStyle.func_150227_a(Boolean.valueOf(true));
                        break;
                    }
                    case ITALIC: {
                        newStyle.func_150217_b(Boolean.valueOf(true));
                        break;
                    }
                    case UNDERLINE: {
                        newStyle.func_150228_d(Boolean.valueOf(true));
                        break;
                    }
                    case STRIKETHROUGH: {
                        newStyle.func_150225_c(Boolean.valueOf(true));
                        break;
                    }
                    case OBFUSCATED: {
                        newStyle.func_150237_e(Boolean.valueOf(true));
                        break;
                    }
                }
                currentStyle = newStyle;
                continue;
            }
            segment.append(c);
        }
        if (segment.length() > 0) {
            ChatComponentText part = new ChatComponentText(segment.toString());
            part.func_150255_a(currentStyle.func_150232_l());
            fullComponent.func_150257_a((IChatComponent)part);
        }
        player.func_145747_a((IChatComponent)fullComponent);
    }

    private static EnumChatFormatting getByCode(char code) {
        for (EnumChatFormatting format : EnumChatFormatting.values()) {
            if (format.func_96298_a() != code) continue;
            return format;
        }
        return null;
    }

    static {
        LogUtil.init();
    }
}

