/*
 * Decompiled with CFR 0.152.
 */
package net.cloudygaming.betterheropackreloading.command;

import com.fiskmods.heroes.pack.HeroPackEngine;
import com.fiskmods.heroes.pack.exception.HeroPackException;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.cloudygaming.betterheropackreloading.BetterHeroPackReloading;
import net.cloudygaming.betterheropackreloading.LogUtil;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class BHPRCommand
extends CommandBase {
    public String func_71517_b() {
        return "betterheropackreloading";
    }

    public List<String> func_71514_a() {
        return Lists.newArrayList((Object[])new String[]{"bhpr"});
    }

    public String func_71518_a(ICommandSender sender) {
        return "/betterheropackreloading <debug|forcereload>";
    }

    public int func_82362_a() {
        return 0;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        switch (args[0].toLowerCase()) {
            case "debug": {
                Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                try (CloseableHttpClient client = BetterHeroPackReloading.createHttpClient();){
                    StringBuilder contentBuilder = new StringBuilder();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(LogUtil.getLatestLog().toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            contentBuilder.append(line).append("\n");
                        }
                    }
                    String encoded = "content=" + URLEncoder.encode(contentBuilder.toString(), "UTF-8");
                    HttpPost request = new HttpPost("https://api.mclo.gs/1/log");
                    request.setHeader("Content-Type", "application/x-www-form-urlencoded");
                    request.setEntity((HttpEntity)new StringEntity(encoded, StandardCharsets.UTF_8));
                    try (CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
                        String json = EntityUtils.toString((HttpEntity)response.getEntity());
                        HashMap jsonMap = new HashMap();
                        try {
                            jsonMap = (HashMap)gson.fromJson(json, new TypeToken<HashMap<Object, Object>>(){}.getType());
                        }
                        catch (JsonSyntaxException jsonSyntaxException) {
                            // empty catch block
                        }
                        String url = jsonMap.getOrDefault("url", "");
                        if (url.isEmpty()) {
                            LogUtil.sendMessage("&cFailed to upload log.");
                            return;
                        }
                        sender.func_145747_a(new ChatComponentText("Log uploaded to: ").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GREEN)).func_150257_a(new ChatComponentText(url).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY).func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, url)))));
                        LogUtil.sendMessage("&aClick the link above to copy the URL to your clipboard.");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            case "forcereload": {
                try {
                    HeroPackEngine.INSTANCE.reloadClient(HeroPackEngine.ResourceReloadScope.ALL, true);
                    break;
                }
                catch (HeroPackException e) {
                    LogUtil.log("Failed to reload resources with exception:\n" + Arrays.toString(e.getStackTrace()));
                    LogUtil.sendMessage("Failed to reload resources. Check the logs for more information.");
                }
            }
        }
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        return args.length == 1 ? BHPRCommand.func_71530_a((String[])args, (String[])new String[]{"debug", "forcereload"}) : null;
    }
}

