/*
 * Decompiled with CFR 0.152.
 */
package net.cloudygaming.betterheropackreloading.mixin;

import com.fiskmods.heroes.common.network.MessageHeroPacks;
import com.fiskmods.heroes.common.network.SHNetworkManager;
import com.fiskmods.heroes.pack.AbstractHeroPackSerializer;
import com.fiskmods.heroes.pack.HeroPackEngine;
import com.fiskmods.heroes.pack.HeroPackLoader;
import com.fiskmods.heroes.pack.HeroPackSerializer;
import com.fiskmods.heroes.pack.IHeroPackObjectLoader;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.llamalad7.mixinextras.sugar.Local;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.cloudygaming.betterheropackreloading.BetterHeroPackReloading;
import net.cloudygaming.betterheropackreloading.Config;
import net.cloudygaming.betterheropackreloading.DebugUtils;
import net.cloudygaming.betterheropackreloading.LogUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HeroPackEngine.class}, remap=false)
public abstract class HeroPackEngineMixin {
    @Shadow
    private List<ByteBuf> receivedSlices;
    @Shadow
    private boolean receivedAll;

    @Inject(method={"onPlayerTick"}, at={@At(value="INVOKE", target="Lcom/fiskmods/heroes/common/proxy/CommonProxy;openReloadScreen()Ljava/lang/Runnable;", shift=At.Shift.BEFORE)}, cancellable=true)
    public void onPlayerTickINVOKE(TickEvent.PlayerTickEvent event, CallbackInfo ci, @Local ByteBuf buf, @Local int i, @Local HeroPackEngine.ResourceReloadScope scope, @Local(ordinal=0) boolean flushSoundCache, @Local(ordinal=1) boolean fromServer, @Local HeroPackSerializer serializer) {
        LogUtil.log("Loaded client heropacks: " + HeroPackLoader.INSTANCE.getPacks().stream().map(pack -> pack.domain).collect(Collectors.toSet()), false);
        try {
            serializer.fromBytes(buf.slice());
        }
        catch (IOException e) {
            LogUtil.log("Failed to set serializer info from bytebuffer bytes");
        }
        Map[] data = null;
        Field dataField = null;
        try {
            dataField = serializer.getClass().getDeclaredField("data");
            dataField.setAccessible(true);
            data = (Map[])dataField.get(serializer);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LogUtil.log("Failed to get data field from serializer");
        }
        if (data != null) {
            this.receivedSlices.clear();
            if (data[0] == null) {
                if (BetterHeroPackReloading.heropackJsonMaps.isEmpty() && !BetterHeroPackReloading.isFakeServer) {
                    LogUtil.log("Server has no hero packs, skipping reload");
                    this.receivedAll = false;
                    ci.cancel();
                    return;
                }
                BetterHeroPackReloading.heropackJsonMaps.clear();
                BetterHeroPackReloading.heropackInfoMaps.clear();
            } else {
                boolean reloadHeroPacks = false;
                boolean comparePacks = false;
                HashSet dataEntries = new HashSet(data[0].entrySet());
                HashSet<String> serverDomains = new HashSet<String>();
                for (Map.Entry entry : dataEntries) {
                    Map map = (Map)new GsonBuilder().disableHtmlEscaping().create().fromJson(String.valueOf(entry.getValue()), Map.class);
                    String domain = String.valueOf(map.get("domain"));
                    serverDomains.add(domain);
                    if (HeroPackLoader.INSTANCE.getPack(domain) == null) {
                        reloadHeroPacks = true;
                        LogUtil.log("&cHeroPack \"&e" + domain + "&c\" from the server is not loaded on the client.", true);
                        continue;
                    }
                    comparePacks = true;
                }
                for (String string : BetterHeroPackReloading.heropackJsonMaps.keySet()) {
                    if (HeroPackLoader.INSTANCE.getPack(string) == null || serverDomains.contains(string) || Config.IGNORE_EXTRA_LOCAL_PACKS) continue;
                    LogUtil.log("&cHeroPack \"&e" + string + "&c\" from the client is not loaded on the server.", true);
                    LogUtil.log("&cEnable \"&eIgnore Extra Local Packs&c\" in the config to ignore this message.", true);
                    reloadHeroPacks = true;
                    break;
                }
                if (BetterHeroPackReloading.isFakeServer) {
                    reloadHeroPacks = true;
                }
                if (comparePacks && !reloadHeroPacks) {
                    try {
                        reloadHeroPacks = HeroPackEngineMixin.betterHeropackReloading$compareHeroPacks(data, false);
                    }
                    catch (NoClassDefFoundError e) {
                        LogUtil.log("Failed to compare hero packs");
                        reloadHeroPacks = false;
                    }
                }
                try {
                    dataField.set(serializer, data);
                }
                catch (Exception e) {
                    LogUtil.log("Failed to set data field in serializer");
                }
                if (!BetterHeroPackReloading.isOfficialServer && Config.LOAD_OFFICIAL_SERVER_PACKS && !BetterHeroPackReloading.hasNotifiedServerPacksConfig) {
                    BetterHeroPackReloading.hasNotifiedServerPacksConfig = true;
                    LogUtil.log("&cIf you are not using this mod for the official server, disable \"&eLoad Official Server Packs&c\" in the config.", true);
                }
                if (!reloadHeroPacks) {
                    LogUtil.log("All good! Cancelling HeroPack reload");
                    SHNetworkManager.wrapper.sendToServer((IMessage)new MessageHeroPacks.FinishSync());
                    ci.cancel();
                }
                try {
                    HeroPackEngineMixin.betterHeropackReloading$compareHeroPacks(data, true);
                }
                catch (NoClassDefFoundError e) {
                    LogUtil.log("Failed to compare hero packs");
                }
            }
        }
        this.receivedAll = false;
    }

    @Unique
    private static boolean betterHeropackReloading$compareHeroPacks(Map<Object, Object>[] data, boolean onlyWrite) {
        if (onlyWrite) {
            BetterHeroPackReloading.heropackJsonMaps.clear();
            BetterHeroPackReloading.heropackInfoMaps.clear();
        }
        boolean reloadHeroPacks = false;
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        Set domains = !onlyWrite ? HeroPackLoader.INSTANCE.getPacks().stream().map(pack -> pack.domain).collect(Collectors.toSet()) : new HashSet(data[0].entrySet().stream().map(entry -> {
            Map map = (Map)gson.fromJson(String.valueOf(entry.getValue()), Map.class);
            return BetterHeroPackReloading.replaceProblematicCharacters(String.valueOf(map.get("domain")));
        }).collect(Collectors.toSet()));
        block3: for (String domain : domains) {
            if (reloadHeroPacks) break;
            String heropackJson = null;
            for (Map.Entry<Object, Object> entry2 : data[0].entrySet()) {
                Object value = entry2.getValue();
                String jsonDomain = String.valueOf(((Map)gson.fromJson(String.valueOf(value), Map.class)).get("domain"));
                if (jsonDomain.equals("fiskheroes") || jsonDomain.equals("fisktag") || !jsonDomain.equals(domain)) continue;
                heropackJson = String.valueOf(value);
                break;
            }
            if (heropackJson == null) continue;
            HashMap jsonMap = (HashMap)gson.fromJson(heropackJson, new TypeToken<HashMap<Object, Object>>(){}.getType());
            if (onlyWrite) {
                BetterHeroPackReloading.heropackJsonMaps.put(domain, jsonMap);
            } else if (BetterHeroPackReloading.heropackJsonMaps.containsKey(domain)) {
                HashMap<Object, Object> linesMap = BetterHeroPackReloading.heropackJsonMaps.get(domain);
                if (!linesMap.equals(jsonMap)) {
                    LogUtil.log("&cheropack.json for \"&e" + domain + "&c\" is different from the server.", true);
                    reloadHeroPacks = true;
                    break;
                }
            } else {
                LogUtil.log("&cheropack.json for \"&e" + domain + "&c\" is not found on the client.", true);
                reloadHeroPacks = true;
                break;
            }
            try {
                Field LOADERSField = AbstractHeroPackSerializer.class.getDeclaredField("LOADERS");
                LOADERSField.setAccessible(true);
                for (IHeroPackObjectLoader loader : (IHeroPackObjectLoader[])LOADERSField.get(null)) {
                    if (loader == null || data[loader.index()] == null) continue;
                    HashMap<String, String> fromServerMap = new HashMap<String, String>();
                    for (Map.Entry<Object, Object> entry3 : data[loader.index()].entrySet()) {
                        Object key = entry3.getKey();
                        if (!(key instanceof String) || !key.toString().startsWith(domain)) continue;
                        fromServerMap.put(BetterHeroPackReloading.replaceProblematicCharacters(key.toString()), BetterHeroPackReloading.replaceProblematicCharacters(entry3.getValue().toString()));
                    }
                    if (onlyWrite) {
                        HashMap<String, HashMap<String, String>> loaderToResourceLocation = new HashMap<String, HashMap<String, String>>();
                        loaderToResourceLocation.put(loader.name().toLowerCase().replace(" ", "_"), fromServerMap);
                        BetterHeroPackReloading.heropackInfoMaps.put(domain, loaderToResourceLocation);
                        continue;
                    }
                    if (!BetterHeroPackReloading.heropackInfoMaps.containsKey(domain) || !BetterHeroPackReloading.heropackInfoMaps.get(domain).containsKey(loader.name().toLowerCase().replace(" ", "_"))) continue;
                    HashMap<String, String> localMap = BetterHeroPackReloading.heropackInfoMaps.get(domain).get(loader.name().toLowerCase().replace(" ", "_"));
                    if (fromServerMap.isEmpty() && !localMap.isEmpty()) {
                        LogUtil.log("&cDomain \"&e" + domain + "&c\" has no " + loader.name().toLowerCase() + " from the server, either the server doesn't have the heropack, or the versions are different", true);
                        reloadHeroPacks = true;
                        continue block3;
                    }
                    if (fromServerMap.equals(localMap)) continue;
                    LogUtil.log("&c" + loader.name().toLowerCase() + " for \"&e" + domain + "&c\" is different from the server", true);
                    LogUtil.log("DEBUG_MODE: " + Config.DEBUG_MODE);
                    if (Config.DEBUG_MODE) {
                        DebugUtils.equals(fromServerMap, localMap);
                    }
                    reloadHeroPacks = true;
                    continue block3;
                }
            }
            catch (NoSuchFieldException e) {
                LogUtil.log("Failed to get field LOADERS from AbstractHeroPackSerializer class");
            }
            catch (IllegalAccessException e) {
                LogUtil.log("Failed access field LOADERS");
            }
        }
        return reloadHeroPacks;
    }
}

