/*
 * Decompiled with CFR 0.152.
 */
package net.cloudygaming.betterheropackreloading;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.reflect.TypeToken;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipFile;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import net.cloudygaming.betterheropackreloading.Config;
import net.cloudygaming.betterheropackreloading.FakeServerWarningScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.GuiConnecting;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="betterheropackreloading", version="1.0.0", name="Better HeroPack Reloading", acceptedMinecraftVersions="[1.7.10]", acceptableRemoteVersions="*")
public class BetterHeroPackReloading {
    private static final String API_KEY = "ptlc_L8izaDt4ThUpHN9SEBUOYb49o5MPZYRfJmkvcMmCF3A";
    public static boolean isFakeServer = false;
    public static boolean hasFakeServerScreenOpened = false;
    public static boolean HAS_LOADED_SERVER_PACKS = false;
    public static HashMap<String, HashMap<Object, Object>> heropackJsonMaps = new HashMap();
    public static HashMap<String, HashMap<String, HashMap<String, String>>> heropackInfoMaps = new HashMap();
    public static final ImmutableSet<String> CREATORS = ImmutableSet.of((Object)"62e2746c-3f6a-40b9-b54b-630a9f731c49", (Object)"fa1c3bff-e7cc-44d3-bc7c-feac03d12718");
    public static IIcon creatorGem;
    public static Logger LOGGER;
    public static Logger DEBUG_LOGGER;

    public static String getEscapedString(String string) {
        return StringEscapeUtils.escapeJson((String)string.replaceAll("(?<!\\\\)/", "%SLASH_ESCAPE%")).replace("%SLASH_ESCAPE%", "/");
    }

    public static HashMap<Object, Object> toHeropackJsonMap(String json, String domain) {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        HashMap<Object, Object> heropackJsonMap = new HashMap<Object, Object>();
        for (String jsonEntry : new HashSet((Collection)gson.fromJson(json, new TypeToken<Set<String>>(){}.getType()))) {
            HashMap jsonMap = (HashMap)gson.fromJson(jsonEntry, new TypeToken<HashMap<Object, Object>>(){}.getType());
            if (!jsonMap.get("domain").equals(domain)) continue;
            heropackJsonMap.putAll(jsonMap);
        }
        return heropackJsonMap;
    }

    public static String replaceProblematicCharacters(String original) {
        return original.replaceAll("[^\\x00-\\x7F]", "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getServerHeroPacks() {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        ArrayList<String> heroPacks = new ArrayList<String>();
        String API_URL = "https://panel.cloudygaming.net/api/client/servers/7f5cfeee/files/list";
        try {
            CloseableHttpClient client = BetterHeroPackReloading.createHttpClient();
            try {
                HashMap jsonMap;
                HttpGet request = new HttpGet(API_URL);
                request.setHeader("Authorization", "Bearer ptlc_L8izaDt4ThUpHN9SEBUOYb49o5MPZYRfJmkvcMmCF3A");
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                String json = EntityUtils.toString((HttpEntity)response.getEntity());
                try {
                    jsonMap = (HashMap)gson.fromJson(json, new TypeToken<HashMap<Object, Object>>(){}.getType());
                }
                catch (JsonSyntaxException e) {
                    LOGGER.error("Failed to fetch heropacks from server.");
                    ArrayList<String> arrayList = heroPacks;
                    if (client == null) return arrayList;
                    client.close();
                    return arrayList;
                }
                ArrayList data = (ArrayList)jsonMap.get("data");
                Iterator iterator = data.iterator();
                while (iterator.hasNext()) {
                    LinkedTreeMap object = (LinkedTreeMap)iterator.next();
                    LinkedTreeMap attributes = (LinkedTreeMap)object.get((Object)"attributes");
                    String fileName = (String)attributes.get((Object)"name");
                    if (!fileName.endsWith(".zip")) continue;
                    heroPacks.add(fileName);
                }
                return heroPacks;
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return heroPacks;
    }

    public static List<ZipFile> getServerHeroPackFiles() {
        List<String> heroPacks = BetterHeroPackReloading.getServerHeroPacks();
        ArrayList<ZipFile> heroPackFiles = new ArrayList<ZipFile>();
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        for (String heroPack : heroPacks) {
            String API_URL = "https://panel.cloudygaming.net/api/client/servers/7f5cfeee/files/download?file=%2F" + URLEncoder.encode(heroPack);
            try {
                CloseableHttpClient client = BetterHeroPackReloading.createHttpClient();
                try {
                    HttpGet request = new HttpGet(API_URL);
                    request.setHeader("Authorization", "Bearer ptlc_L8izaDt4ThUpHN9SEBUOYb49o5MPZYRfJmkvcMmCF3A");
                    CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                    try {
                        String json = EntityUtils.toString((HttpEntity)response.getEntity());
                        HashMap jsonMap = (HashMap)gson.fromJson(json, new TypeToken<HashMap<Object, Object>>(){}.getType());
                        LinkedTreeMap attributes = (LinkedTreeMap)jsonMap.get("attributes");
                        String url = (String)attributes.get((Object)"url");
                        File file = BetterHeroPackReloading.downloadHeroPack(url, heroPack);
                        if (file == null) continue;
                        heroPackFiles.add(new ZipFile(file));
                    }
                    finally {
                        if (response == null) continue;
                        response.close();
                    }
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return heroPackFiles;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static File downloadHeroPack(String fileUrl, String heroPack) {
        File cloudyDirectory = Paths.get("cloudy", new String[0]).toFile();
        if (!cloudyDirectory.exists()) {
            cloudyDirectory.mkdir();
        }
        try (CloseableHttpClient client = BetterHeroPackReloading.createHttpClient();){
            File file;
            block15: {
                HttpGet request = new HttpGet(fileUrl);
                CloseableHttpResponse response = client.execute((HttpUriRequest)request);
                try {
                    InputStream inputStream = response.getEntity().getContent();
                    Path savePath = Paths.get("cloudy", heroPack);
                    Files.copy(inputStream, savePath, StandardCopyOption.REPLACE_EXISTING);
                    file = savePath.toFile();
                    if (response == null) break block15;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static CloseableHttpClient createHttpClient() {
        CloseableHttpClient closeableHttpClient;
        block8: {
            InputStream caInput = BetterHeroPackReloading.class.getResourceAsStream("/certs/isrgrootx1.pem");
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Certificate ca = cf.generateCertificate(caInput);
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(null, null);
                ks.setCertificateEntry("isrgrootx1", ca);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(ks);
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, tmf.getTrustManagers(), new SecureRandom());
                closeableHttpClient = HttpClients.custom().setSslcontext(sslContext).build();
                if (caInput == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (caInput != null) {
                        try {
                            caInput.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return HttpClients.createDefault();
                }
            }
            caInput.close();
        }
        return closeableHttpClient;
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        Config.loadConfig(event.getSuggestedConfigurationFile());
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.gui instanceof GuiConnecting) {
            ServerData data = Minecraft.func_71410_x().func_147104_D();
            if (data == null) {
                return;
            }
            String ip = data.field_78845_b;
            if (ip == null || !ip.equalsIgnoreCase("playfiskheroes.net")) {
                isFakeServer = false;
                return;
            }
            isFakeServer = true;
            if (hasFakeServerScreenOpened) {
                return;
            }
            try {
                Field netManagerField = GuiConnecting.class.getDeclaredField("field_146371_g");
                netManagerField.setAccessible(true);
                Object networkManager = null;
                for (int attempts = 0; networkManager == null && attempts < 20; ++attempts) {
                    Thread.sleep(50L);
                    networkManager = netManagerField.get(event.gui);
                }
                if (networkManager != null) {
                    Method closeChannel = networkManager.getClass().getMethod("closeChannel", IChatComponent.class);
                    closeChannel.invoke(networkManager, new ChatComponentText("Server connection closed"));
                } else {
                    System.err.println("[BetterHeroPackReloading] Failed to close connection: NetworkManager was not initialized in time.");
                }
            }
            catch (IllegalAccessException | InterruptedException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
            event.gui = new FakeServerWarningScreen();
            hasFakeServerScreenOpened = true;
        }
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() != 1) {
            return;
        }
        creatorGem = event.map.func_94245_a("betterheropackreloading:creator_gem");
    }

    static {
        LOGGER = LogManager.getLogger((String)"Better HeroPack Reloading");
        DEBUG_LOGGER = LogManager.getLogger((String)"Better HeroPack Reloading - Debug");
    }
}

