/*
 * Decompiled with CFR 0.152.
 */
package net.cloudygaming.betterheropackreloading.mixin;

import com.fiskmods.heroes.common.network.MessageHeroPacks;
import com.fiskmods.heroes.common.network.SHNetworkManager;
import com.fiskmods.heroes.pack.AbstractHeroPackSerializer;
import com.fiskmods.heroes.pack.HeroPackEngine;
import com.fiskmods.heroes.pack.HeroPackLoader;
import com.fiskmods.heroes.pack.HeroPackSerializer;
import com.fiskmods.heroes.pack.IHeroPackObjectLoader;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.llamalad7.mixinextras.sugar.Local;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.cloudygaming.betterheropackreloading.BetterHeroPackReloading;
import net.cloudygaming.betterheropackreloading.Config;
import net.cloudygaming.betterheropackreloading.DebugUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HeroPackEngine.class}, remap=false)
public abstract class HeroPackEngineMixin {
    @Shadow
    private List<ByteBuf> receivedSlices;
    @Shadow
    private boolean receivedAll;

    @Inject(method={"onPlayerTick"}, at={@At(value="INVOKE", target="Lcom/fiskmods/heroes/common/proxy/CommonProxy;openReloadScreen()Ljava/lang/Runnable;", shift=At.Shift.BEFORE)}, cancellable=true)
    public void onPlayerTickINVOKE(TickEvent.PlayerTickEvent event, CallbackInfo ci, @Local ByteBuf buf, @Local int i, @Local HeroPackEngine.ResourceReloadScope scope, @Local(ordinal=0) boolean flushSoundCache, @Local(ordinal=1) boolean fromServer, @Local HeroPackSerializer serializer) {
        BetterHeroPackReloading.DEBUG_LOGGER.warn(HeroPackLoader.INSTANCE.getPacks().stream().map(pack -> pack.domain).collect(Collectors.toSet()));
        try {
            serializer.fromBytes(buf.slice());
        }
        catch (IOException e) {
            BetterHeroPackReloading.DEBUG_LOGGER.warn("Failed to set serializer info from bytebuffer bytes\n{}", new Object[]{e.getMessage()});
        }
        Map[] data = null;
        Field dataField = null;
        try {
            dataField = serializer.getClass().getDeclaredField("data");
            dataField.setAccessible(true);
            data = (Map[])dataField.get(serializer);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            BetterHeroPackReloading.DEBUG_LOGGER.warn("Failed to get data field from serializer\n{}", new Object[]{e.getMessage()});
        }
        if (data != null) {
            this.receivedSlices.clear();
            if (data[0] == null) {
                if (BetterHeroPackReloading.heropackJsonMaps.isEmpty() && !BetterHeroPackReloading.isFakeServer) {
                    BetterHeroPackReloading.LOGGER.info("Server has no hero packs, skipping reload");
                    this.receivedAll = false;
                    ci.cancel();
                    return;
                }
                BetterHeroPackReloading.heropackJsonMaps.clear();
                BetterHeroPackReloading.heropackInfoMaps.clear();
            } else {
                boolean reloadHeroPacks = false;
                boolean comparePacks = false;
                HashSet dataEntries = new HashSet(data[0].entrySet());
                HashSet<String> serverDomains = new HashSet<String>();
                for (Map.Entry entry : dataEntries) {
                    Map map = (Map)new GsonBuilder().disableHtmlEscaping().create().fromJson(String.valueOf(entry.getValue()), Map.class);
                    String domain = String.valueOf(map.get("domain"));
                    serverDomains.add(domain);
                    if (HeroPackLoader.INSTANCE.getPack(domain) == null) {
                        reloadHeroPacks = true;
                        BetterHeroPackReloading.LOGGER.info("{} from the server is not loaded", new Object[]{domain});
                        continue;
                    }
                    comparePacks = true;
                }
                for (String string : BetterHeroPackReloading.heropackJsonMaps.keySet()) {
                    if (HeroPackLoader.INSTANCE.getPack(string) == null || serverDomains.contains(string) || Config.IGNORE_EXTRA_LOCAL_PACKS) continue;
                    BetterHeroPackReloading.LOGGER.info("Server doesn't have {}", new Object[]{string});
                    reloadHeroPacks = true;
                    break;
                }
                if (BetterHeroPackReloading.isFakeServer) {
                    reloadHeroPacks = true;
                }
                if (comparePacks && !reloadHeroPacks) {
                    try {
                        reloadHeroPacks = HeroPackEngineMixin.betterHeropackReloading$compareHeroPacks(data, false);
                    }
                    catch (NoClassDefFoundError e) {
                        BetterHeroPackReloading.LOGGER.warn("Failed to compare hero packs\n{}", new Object[]{e.getMessage()});
                        reloadHeroPacks = false;
                    }
                }
                try {
                    dataField.set(serializer, data);
                }
                catch (Exception e) {
                    BetterHeroPackReloading.DEBUG_LOGGER.warn("Failed to set data field in serializer\n{}", new Object[]{e.getMessage()});
                }
                if (!reloadHeroPacks) {
                    BetterHeroPackReloading.LOGGER.info("All good! Cancelling HeroPack reload");
                    SHNetworkManager.wrapper.sendToServer((IMessage)new MessageHeroPacks.FinishSync());
                    ci.cancel();
                }
                try {
                    HeroPackEngineMixin.betterHeropackReloading$compareHeroPacks(data, true);
                }
                catch (NoClassDefFoundError e) {
                    BetterHeroPackReloading.LOGGER.warn("Failed to compare hero packs\n{}", new Object[]{e.getMessage()});
                }
            }
        }
        this.receivedAll = false;
    }

    @Unique
    private static boolean betterHeropackReloading$compareHeroPacks(Map<Object, Object>[] data, boolean onlyWrite) {
        if (onlyWrite) {
            BetterHeroPackReloading.heropackJsonMaps.clear();
            BetterHeroPackReloading.heropackInfoMaps.clear();
        }
        boolean reloadHeroPacks = false;
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        Set domains = !onlyWrite ? HeroPackLoader.INSTANCE.getPacks().stream().map(pack -> pack.domain).collect(Collectors.toSet()) : new HashSet(data[0].entrySet().stream().map(entry -> {
            Map map = (Map)gson.fromJson(String.valueOf(entry.getValue()), Map.class);
            return BetterHeroPackReloading.replaceProblematicCharacters(String.valueOf(map.get("domain")));
        }).collect(Collectors.toSet()));
        block3: for (String domain : domains) {
            if (reloadHeroPacks) break;
            String heropackJson = null;
            for (Map.Entry<Object, Object> entry2 : data[0].entrySet()) {
                Object value = entry2.getValue();
                String jsonDomain = String.valueOf(((Map)gson.fromJson(String.valueOf(value), Map.class)).get("domain"));
                if (jsonDomain.equals("fiskheroes") || jsonDomain.equals("fisktag") || !jsonDomain.equals(domain)) continue;
                heropackJson = String.valueOf(value);
                break;
            }
            if (heropackJson == null) continue;
            HashMap jsonMap = (HashMap)gson.fromJson(heropackJson, new TypeToken<HashMap<Object, Object>>(){}.getType());
            if (onlyWrite) {
                BetterHeroPackReloading.heropackJsonMaps.put(domain, jsonMap);
            } else if (BetterHeroPackReloading.heropackJsonMaps.containsKey(domain)) {
                HashMap<Object, Object> linesMap = BetterHeroPackReloading.heropackJsonMaps.get(domain);
                if (!linesMap.equals(jsonMap)) {
                    BetterHeroPackReloading.LOGGER.info("heropack.json different for domain {}", new Object[]{domain});
                    reloadHeroPacks = true;
                    break;
                }
            } else {
                BetterHeroPackReloading.LOGGER.info("heropack.json not found for domain {}", new Object[]{domain});
                reloadHeroPacks = true;
                break;
            }
            try {
                Field LOADERSField = AbstractHeroPackSerializer.class.getDeclaredField("LOADERS");
                LOADERSField.setAccessible(true);
                for (IHeroPackObjectLoader loader : (IHeroPackObjectLoader[])LOADERSField.get(null)) {
                    if (loader == null || data[loader.index()] == null) continue;
                    HashMap<String, String> fromServerMap = new HashMap<String, String>();
                    for (Map.Entry<Object, Object> entry3 : data[loader.index()].entrySet()) {
                        Object key = entry3.getKey();
                        if (!(key instanceof String) || !key.toString().startsWith(domain)) continue;
                        fromServerMap.put(BetterHeroPackReloading.replaceProblematicCharacters(key.toString()), BetterHeroPackReloading.replaceProblematicCharacters(entry3.getValue().toString()));
                    }
                    if (onlyWrite) {
                        HashMap<String, HashMap<String, String>> loaderToResourceLocation = new HashMap<String, HashMap<String, String>>();
                        loaderToResourceLocation.put(loader.name().toLowerCase().replace(" ", "_"), fromServerMap);
                        BetterHeroPackReloading.heropackInfoMaps.put(domain, loaderToResourceLocation);
                        continue;
                    }
                    if (!BetterHeroPackReloading.heropackInfoMaps.containsKey(domain) || !BetterHeroPackReloading.heropackInfoMaps.get(domain).containsKey(loader.name().toLowerCase().replace(" ", "_"))) continue;
                    HashMap<String, String> localMap = BetterHeroPackReloading.heropackInfoMaps.get(domain).get(loader.name().toLowerCase().replace(" ", "_"));
                    if (fromServerMap.isEmpty() && !localMap.isEmpty()) {
                        BetterHeroPackReloading.LOGGER.info("Domain {} has no {} from the server, either the server doesn't have the heropack, or the versions are different", new Object[]{domain, loader.name().toLowerCase()});
                        reloadHeroPacks = true;
                        continue block3;
                    }
                    if (fromServerMap.equals(localMap)) continue;
                    BetterHeroPackReloading.LOGGER.info("{} is different for {}", new Object[]{loader.name(), domain});
                    BetterHeroPackReloading.DEBUG_LOGGER.info("DEBUG_MODE: {}", new Object[]{Config.DEBUG_MODE});
                    if (Config.DEBUG_MODE) {
                        DebugUtils.equals(fromServerMap, localMap);
                    }
                    reloadHeroPacks = true;
                    continue block3;
                }
            }
            catch (NoSuchFieldException e) {
                BetterHeroPackReloading.DEBUG_LOGGER.warn("Failed to get field LOADERS from AbstractHeroPackSerializer class\n{}", new Object[]{e.getMessage()});
            }
            catch (IllegalAccessException e) {
                BetterHeroPackReloading.DEBUG_LOGGER.warn("Failed access field LOADERS\n{}", new Object[]{e.getMessage()});
            }
        }
        return reloadHeroPacks;
    }
}

