/*
 * Decompiled with CFR 0.152.
 */
package net.cloudygaming.betterheropackreloading.mixin.error;

import com.fiskmods.heroes.common.arrowtype.ArrowType;
import com.fiskmods.heroes.common.data.effect.StatusEffect;
import com.fiskmods.heroes.common.data.var.DataContainer;
import com.fiskmods.heroes.common.data.var.DataSyncer;
import com.fiskmods.heroes.common.hero.HeroIteration;
import com.fiskmods.heroes.common.network.MessageSyncBase;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.cloudygaming.betterheropackreloading.BetterHeroPackReloading;
import net.cloudygaming.betterheropackreloading.Config;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MessageSyncBase.class}, remap=false)
public abstract class MessageSyncMixin {
    @Shadow
    protected DataContainer dataContainer;
    @Shadow
    protected HeroIteration wornSuit;
    @Shadow
    protected Map<ArrowType, Integer> arrowCollection;
    @Shadow
    protected Set<HeroIteration> vanityCollection;
    @Shadow
    protected List<StatusEffect> activeEffects;
    @Shadow
    protected float temperature;

    @Inject(method={"fromBytes"}, at={@At(value="HEAD")}, cancellable=true)
    public void fromBytes(ByteBuf buf, CallbackInfo ci) {
        block22: {
            ci.cancel();
            this.dataContainer = new DataContainer(DataSyncer.PLAYER);
            try {
                this.dataContainer.fromBytes(buf);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (buf.readBoolean()) {
                try {
                    this.wornSuit = HeroIteration.get((String)ByteBufUtils.readUTF8String((ByteBuf)buf));
                }
                catch (IndexOutOfBoundsException e) {
                    if (!Config.DEBUG_MODE) break block22;
                    BetterHeroPackReloading.DEBUG_LOGGER.warn("Error setting worn suit. Please report this if this has caused any issues in-game.");
                }
            }
        }
        this.arrowCollection = new HashMap<ArrowType, Integer>();
        this.vanityCollection = new HashSet<HeroIteration>();
        this.activeEffects = new ArrayList<StatusEffect>();
        int i = 0;
        try {
            i = buf.readByte() & 0xFF;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        for (int j = 0; j < i; ++j) {
            ArrowType arrow = ArrowType.getArrowById((int)buf.readShort());
            int b = 0;
            try {
                b = buf.readByte() & 0xFF;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (arrow == null) continue;
            this.arrowCollection.put(arrow, b);
        }
        try {
            i = buf.readByte() & 0xFF;
        }
        catch (IndexOutOfBoundsException j) {
            // empty catch block
        }
        for (int j = 0; j < i; ++j) {
            try {
                HeroIteration iter = HeroIteration.lookup((String)ByteBufUtils.readUTF8String((ByteBuf)buf));
                if (iter == null) continue;
                this.vanityCollection.add(iter);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                if (!Config.DEBUG_MODE) continue;
                BetterHeroPackReloading.DEBUG_LOGGER.warn("Error setting vanity collection. Please report this if this has caused any issues in-game.");
            }
        }
        try {
            this.temperature = buf.readFloat();
        }
        catch (IndexOutOfBoundsException e) {
            this.temperature = 36.0f;
        }
        try {
            i = buf.readByte() & 0xFF;
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        for (int j = 0; j < i; ++j) {
            try {
                StatusEffect effect = StatusEffect.fromBytes((ByteBuf)buf);
                if (effect == null) continue;
                this.activeEffects.add(effect);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }
}

