/*
 * Decompiled with CFR 0.152.
 */
package net.cloudygaming.betterheropackreloading.mixin;

import com.fiskmods.heroes.pack.AbstractHeroPackSerializer;
import com.fiskmods.heroes.pack.HeroPack;
import com.fiskmods.heroes.pack.HeroPackDomainFilter;
import com.fiskmods.heroes.pack.IHeroPackObjectLoader;
import com.fiskmods.heroes.pack.ReloadContainer;
import com.fiskmods.heroes.util.FileHelper;
import com.llamalad7.mixinextras.sugar.Local;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.cloudygaming.betterheropackreloading.BetterHeroPackReloading;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HeroPack.class}, remap=false)
public abstract class HeroPackMixin {
    @Shadow
    @Final
    private static Predicate<String> PRED_ANY_DATA;
    @Shadow
    @Final
    private static Pattern PATTERN_ANY_DOMAIN;
    @Shadow
    @Final
    private HeroPackDomainFilter domainFilter;
    @Shadow
    private AbstractHeroPackSerializer serializer;

    @Shadow
    protected abstract void logNameNotLowercase(String var1);

    @Inject(method={"onDiscoverFromFile"}, at={@At(value="INVOKE", target="Lcom/fiskmods/heroes/pack/IHeroPackObjectLoader;load(Lcom/fiskmods/heroes/pack/IHeroPack;Lcom/fiskmods/heroes/pack/ReloadContainer;Lnet/minecraft/util/ResourceLocation;Ljava/util/concurrent/Callable;Lcom/fiskmods/heroes/pack/AbstractHeroPackSerializer;)V", shift=At.Shift.BEFORE)})
    public void onDiscoverFromFileINVOKEFILE(ZipFile zip, ReloadContainer reload, CallbackInfo ci, @Local IHeroPackObjectLoader loader, @Local ZipEntry e, @Local Matcher m) {
        try {
            String domain = m.group(1);
            String lines = FileHelper.readLines((BufferedReader)new BufferedReader(new InputStreamReader(zip.getInputStream(e))));
            HeroPackMixin.betterHeroPackReloading$put(loader, domain, m.group(2), lines);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Inject(method={"onDiscoverFromDirectory"}, at={@At(value="INVOKE", target="Lcom/fiskmods/heroes/pack/IHeroPackObjectLoader;load(Lcom/fiskmods/heroes/pack/IHeroPack;Lcom/fiskmods/heroes/pack/ReloadContainer;Lnet/minecraft/util/ResourceLocation;Ljava/util/concurrent/Callable;Lcom/fiskmods/heroes/pack/AbstractHeroPackSerializer;)V", shift=At.Shift.BEFORE)})
    public void onDiscoverFromFileINVOKEFOLDER(File root, ReloadContainer reload, CallbackInfo ci, @Local IHeroPackObjectLoader loader, @Local(name={"file"}) File file, @Local(name={"domain"}) String domain, @Local ResourceLocation id) {
        try {
            String fileName = id.func_110623_a();
            String lines = FileHelper.readLines((BufferedReader)new BufferedReader(new InputStreamReader(new FileInputStream(file))));
            HeroPackMixin.betterHeroPackReloading$put(loader, domain, fileName, lines);
        }
        catch (IOException e) {
            BetterHeroPackReloading.DEBUG_LOGGER.warn("Couldn't read file lines for {}\n{}", new Object[]{file.getPath(), e.getMessage()});
        }
    }

    @Unique
    private static void betterHeroPackReloading$put(IHeroPackObjectLoader loader, String domain, String fileName, String lines) {
        if (!domain.equals("fiskheroes") && !domain.equals("fisktag")) {
            domain = BetterHeroPackReloading.replaceProblematicCharacters(domain);
            fileName = BetterHeroPackReloading.replaceProblematicCharacters(fileName);
            lines = BetterHeroPackReloading.replaceProblematicCharacters(lines);
            String resourceLocation = domain + ":" + fileName;
            BetterHeroPackReloading.heropackInfoMaps.putIfAbsent(domain, new HashMap());
            BetterHeroPackReloading.heropackInfoMaps.get(domain).putIfAbsent(loader.name().toLowerCase().replace(" ", "_"), new HashMap());
            HashMap<String, String> resourceLocationToLines = new HashMap<String, String>((Map)BetterHeroPackReloading.heropackInfoMaps.get(domain).get(loader.name().toLowerCase().replace(" ", "_")));
            resourceLocationToLines.put(resourceLocation, lines);
            HashMap<String, HashMap<String, String>> loaderToResourceLocation = new HashMap<String, HashMap<String, String>>((Map)BetterHeroPackReloading.heropackInfoMaps.get(domain));
            loaderToResourceLocation.put(loader.name().toLowerCase().replace(" ", "_"), resourceLocationToLines);
            BetterHeroPackReloading.heropackInfoMaps.put(domain, loaderToResourceLocation);
        }
    }
}

