/*
 * Decompiled with CFR 0.152.
 */
package net.cloudygaming.betterheropackreloading.mixin.error;

import com.fiskmods.heroes.pack.HeroPackSnooper;
import com.google.common.base.Charsets;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HeroPackSnooper.class}, remap=false)
public abstract class SnooperMixin {
    @Inject(method={"fromBytes"}, at={@At(value="HEAD")}, cancellable=true)
    public void fromBytes(ByteBuf buf, CallbackInfo ci) throws IOException {
        ci.cancel();
        try {
            int size = buf.readShort();
            for (int i = 0; i < size; ++i) {
                ResourceLocation location = new ResourceLocation(SnooperMixin.betterHeroPackReloading$readUTF8String(buf));
                int bufInt = buf.readInt();
                if (bufInt < 0) {
                    bufInt = 0;
                }
                ((HeroPackSnooper)this).storeData(location, buf.readBytes(bufInt).array());
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Unique
    private static String betterHeroPackReloading$readUTF8String(ByteBuf from) {
        int len = 0;
        try {
            len = ByteBufUtils.readVarInt((ByteBuf)from, (int)2);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        String str = from.toString(from.readerIndex(), len, Charsets.UTF_8);
        from.readerIndex(from.readerIndex() + len);
        return str;
    }
}

