/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.fallingsand;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import magnusmakesgames.fallingsand.FallingSandConfig;
import magnusmakesgames.fallingsand.FallingSandConfigManager;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallingSand
implements ModInitializer {
    public static final String MOD_ID = "fallingsand";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"fallingsand");
    public static FallingSandConfig CONFIG = null;
    private static final class_5819 sandFallRandom = class_5819.method_43047();

    public void onInitialize() {
        LOGGER.info("Loading Falling Sand Mod");
        FallingSandConfigManager.load();
    }

    private static boolean isBlockAffected(class_2248 block) {
        class_2960 id = class_7923.field_41175.method_10221((Object)block);
        for (FallingSandConfig.AffectedBlock affectedBlock : FallingSandConfigManager.CONFIG.additionalAffectedBlocks) {
            if (!affectedBlock.blockName.equals(id.toString())) continue;
            return true;
        }
        return false;
    }

    public static void scheduleBlockTick(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.method_8503() == null) {
            return;
        }
        List players = world.method_8503().method_3760().method_14571();
        boolean playerNearby = false;
        for (class_3222 player : players) {
            if (!(player.method_24515().method_10262((class_2382)pos) < 4096.0)) continue;
            playerNearby = true;
            break;
        }
        if (playerNearby) {
            world.method_39279(pos, state.method_26204(), FallingSandConfigManager.CONFIG.sandFallDelay);
        }
    }

    public static boolean isValid(class_2248 block) {
        return FallingSand.getFallChance(block) >= 0.0f;
    }

    public static float getFallChance(class_2248 block) {
        FallingSandConfig config = FallingSandConfigManager.CONFIG;
        if (config.applyToAllBasicFallingBlocks && block instanceof class_2346 && block != class_2246.field_10535 && block != class_2246.field_10105 && block != class_2246.field_10414) {
            return 1.0f - config.defaultSlideChance;
        }
        if (!config.additionalAffectedBlocks.isEmpty() && FallingSand.isBlockAffected(block)) {
            class_2960 id = class_7923.field_41175.method_10221((Object)block);
            for (FallingSandConfig.AffectedBlock affectedBlock : FallingSandConfigManager.CONFIG.additionalAffectedBlocks) {
                if (!affectedBlock.blockName.equals(id.toString())) continue;
                return 1.0f - affectedBlock.slideChance;
            }
        }
        return -1.0f;
    }

    private static void moveBlock(class_3218 world, class_2680 state, class_2338 oldPos, class_2338 newPos, boolean tickUpDiagonal) {
        world.method_8652(newPos, state, 3);
        world.method_8652(oldPos, class_2246.field_10124.method_9564(), 3);
        world.method_39279(newPos, state.method_26204(), FallingSandConfigManager.CONFIG.sandFallDelay);
        if (tickUpDiagonal) {
            FallingSand.updateDiagonals((class_1937)world, oldPos);
        }
    }

    private static void updateDiagonals(class_1937 world, class_2338 pos) {
        class_2338[] diagonals;
        for (class_2338 diagonal : diagonals = new class_2338[]{pos.method_10069(0, 1, -1), pos.method_10069(0, 1, 1), pos.method_10069(1, 1, 0), pos.method_10069(-1, 1, 0)}) {
            class_2248 block = world.method_8320(diagonal).method_26204();
            if (!(block instanceof class_2346)) continue;
            world.method_39279(diagonal, block, FallingSandConfigManager.CONFIG.sandFallDelay);
            return;
        }
    }

    private static boolean canReplace(class_2680 state, boolean replaceFallingBlocks) {
        return state.method_26215() || state.method_45474() || replaceFallingBlocks && FallingSand.isValid(state.method_26204());
    }

    private static boolean canReplace(class_2680 state) {
        return FallingSand.canReplace(state, false);
    }

    public static void simulateSand(class_3218 world, class_2338 pos, class_2680 state) {
        if (FallingSand.canReplace(world.method_8320(pos.method_10074()))) {
            FallingSand.moveBlock(world, state, pos, pos.method_10074(), false);
        } else {
            boolean shouldFall;
            class_2338[] diagonals = new class_2338[]{pos.method_10069(0, -1, -1), pos.method_10069(0, -1, 1), pos.method_10069(1, -1, 0), pos.method_10069(-1, -1, 0)};
            Collections.shuffle(Arrays.asList(diagonals));
            boolean bl = shouldFall = sandFallRandom.method_43057() > FallingSand.getFallChance(state.method_26204());
            if (shouldFall) {
                for (class_2338 diagonal : diagonals) {
                    if (!FallingSand.canReplace(world.method_8320(diagonal)) || !FallingSand.canReplace(world.method_8320(diagonal.method_10069(0, 1, 0)), true)) continue;
                    FallingSand.moveBlock(world, state, pos, diagonal, true);
                    return;
                }
            }
        }
    }
}

