/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.fallingsand;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import magnusmakesgames.fallingsand.FallingSand;
import magnusmakesgames.fallingsand.FallingSandConfig;

public class FallingSandConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/falling_sand.json");
    public static FallingSandConfig CONFIG = new FallingSandConfig();

    public static void load() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                JsonElement root = JsonParser.parseReader((Reader)reader);
                if (!root.isJsonObject()) {
                    FallingSand.LOGGER.error("Config is not a JSON object, regenerating...");
                    FallingSandConfigManager.save();
                    return;
                }
                JsonObject obj = root.getAsJsonObject();
                CONFIG = new FallingSandConfig();
                if (obj.has("applyToAllBasicFallingBlocks")) {
                    FallingSandConfigManager.CONFIG.applyToAllBasicFallingBlocks = obj.get("applyToAllBasicFallingBlocks").getAsBoolean();
                }
                if (obj.has("sandFallDelay")) {
                    FallingSandConfigManager.CONFIG.sandFallDelay = obj.get("sandFallDelay").getAsInt();
                }
                if (obj.has("defaultSlideChance")) {
                    FallingSandConfigManager.CONFIG.defaultSlideChance = obj.get("defaultSlideChance").getAsFloat();
                }
                if (obj.has("additionalAffectedBlocks")) {
                    JsonArray blocks = obj.getAsJsonArray("additionalAffectedBlocks");
                    ArrayList<FallingSandConfig.AffectedBlock> converted = new ArrayList<FallingSandConfig.AffectedBlock>();
                    boolean hasOldEntries = false;
                    for (JsonElement element : blocks) {
                        if (element.isJsonObject()) {
                            JsonObject blockObj = element.getAsJsonObject();
                            String name = blockObj.has("blockName") ? blockObj.get("blockName").getAsString() : "unknown";
                            float chance = blockObj.has("slideChance") ? blockObj.get("slideChance").getAsFloat() : FallingSandConfigManager.CONFIG.defaultSlideChance;
                            converted.add(new FallingSandConfig.AffectedBlock(name, chance));
                            continue;
                        }
                        if (!element.isJsonPrimitive()) continue;
                        hasOldEntries = true;
                        converted.add(new FallingSandConfig.AffectedBlock(element.getAsString(), FallingSandConfigManager.CONFIG.defaultSlideChance));
                    }
                    if (hasOldEntries) {
                        converted.add(new FallingSandConfig.AffectedBlock("minecraft:sand", 0.85f));
                        converted.add(new FallingSandConfig.AffectedBlock("minecraft:red_sand", 0.85f));
                        converted.add(new FallingSandConfig.AffectedBlock("minecraft:gravel", 0.5f));
                    }
                    FallingSandConfigManager.CONFIG.additionalAffectedBlocks = converted;
                }
                FallingSandConfigManager.save();
                FallingSand.LOGGER.info("Loaded Falling Sand config (falling_sand.json).");
            }
            catch (IOException e) {
                FallingSand.LOGGER.error("Failed to read Falling Sand config: " + e.getMessage());
            }
        } else {
            FallingSandConfigManager.save();
        }
    }

    public static void save() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)CONFIG, (Appendable)writer);
            }
            FallingSand.LOGGER.info("Saved falling_sand config.");
        }
        catch (IOException e) {
            FallingSand.LOGGER.error("Failed to write config: " + e.getMessage());
        }
    }
}

