/*
 * Decompiled with CFR 0.152.
 */
package magnusmakesgames.fallingsand.mixin;

import java.util.Arrays;
import java.util.Collections;
import magnusmakesgames.fallingsand.FallingSand;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_4970.class})
public abstract class AbstractBlockMixin {
    @Inject(method={"neighborUpdate"}, at={@At(value="HEAD")}, cancellable=true)
    public void neighborUpdateHead(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify, CallbackInfo ci) {
        if (FallingSand.isValid(state.method_26204())) {
            ci.cancel();
        }
    }

    @Inject(method={"onBlockAdded"}, at={@At(value="HEAD")}, cancellable=true)
    public void onBlockAdded(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify, CallbackInfo ci) {
        if (FallingSand.isValid(state.method_26204())) {
            FallingSand.scheduleBlockTick(world, pos, state);
            ci.cancel();
        }
    }

    @Inject(method={"onStateReplaced"}, at={@At(value="HEAD")})
    public void onStateReplacedHead(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify, CallbackInfo ci) {
        if (FallingSand.isValid(state.method_26204())) {
            FallingSand.scheduleBlockTick(world, pos, state);
        }
    }

    @Inject(method={"getStateForNeighborUpdate"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetStateForNeighborUpdate(class_2680 state, class_2350 dir, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos, CallbackInfoReturnable<class_2680> cir) {
        if (FallingSand.isValid(state.method_26204())) {
            cir.setReturnValue((Object)state);
            cir.cancel();
        }
    }

    @Inject(method={"onStateReplaced"}, at={@At(value="TAIL")})
    public void onStateReplacedTail(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved, CallbackInfo ci) {
        if (state.method_26204() instanceof class_2404) {
            return;
        }
        class_2338[] blocksToUpdate = new class_2338[]{pos.method_10069(0, 1, -1), pos.method_10069(0, 1, 1), pos.method_10069(1, 1, 0), pos.method_10069(-1, 1, 0), pos.method_10069(0, 1, 0), pos.method_10069(0, 0, 1), pos.method_10069(0, 0, -1), pos.method_10069(1, 0, 0), pos.method_10069(-1, 0, 0), pos.method_10069(0, -1, 0), pos.method_10069(0, -1, 1), pos.method_10069(0, -1, -1), pos.method_10069(1, -1, 0), pos.method_10069(-1, -1, 0)};
        Collections.shuffle(Arrays.asList(blocksToUpdate));
        for (class_2338 blockToUpdate : blocksToUpdate) {
            class_2248 block = world.method_8320(blockToUpdate).method_26204();
            if (!FallingSand.isValid(block)) continue;
            FallingSand.scheduleBlockTick(world, blockToUpdate, world.method_8320(blockToUpdate));
        }
    }

    @Inject(method={"scheduledTick"}, at={@At(value="TAIL")})
    private void scheduledTick(class_2680 state, class_3218 world, class_2338 pos, class_5819 random, CallbackInfo ci) {
        class_2248 block = state.method_26204();
        if (FallingSand.isValid(block)) {
            FallingSand.simulateSand(world, pos, state);
        }
    }
}

