/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng;

public class PngChunkCode {
    public static final PngChunkCode IHDR = new PngChunkCode(1229472850, "IHDR");
    public static final PngChunkCode PLTE = new PngChunkCode(1347179589, "PLTE");
    public static final PngChunkCode IDAT = new PngChunkCode(1229209940, "IDAT");
    public static final PngChunkCode IEND = new PngChunkCode(1229278788, "IEND");
    public static final PngChunkCode gAMA = new PngChunkCode(1732332865, "gAMA");
    public static final PngChunkCode bKGD = new PngChunkCode(1649100612, "bKGD");
    public static final PngChunkCode tRNS = new PngChunkCode(1951551059, "tRNS");
    public static final PngChunkCode acTL = new PngChunkCode(1633899596, "acTL");
    public static final PngChunkCode fcTL = new PngChunkCode(1717785676, "fcTL");
    public static final PngChunkCode fdAT = new PngChunkCode(1717846356, "fdAT");
    public final int numeric;
    public final String letters;

    PngChunkCode(int numeric, String letters) {
        this.numeric = numeric;
        this.letters = letters;
    }

    public boolean isCritical() {
        return (this.numeric & 0x20000000) == 0;
    }

    public boolean isAncillary() {
        return (this.numeric & 0x20000000) > 0;
    }

    public boolean isPrivate() {
        return (this.numeric & 0x200000) > 0;
    }

    public boolean isPublic() {
        return (this.numeric & 0x200000) == 0;
    }

    public boolean isReserved() {
        return (this.numeric & 0x2000) > 0;
    }

    public boolean isSafeToCopy() {
        return (this.numeric & 0x20) > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PngChunkCode that = (PngChunkCode)o;
        if (this.numeric != that.numeric) {
            return false;
        }
        return !(this.letters == null ? that.letters != null : !this.letters.equals(that.letters));
    }

    public int hashCode() {
        int result = this.numeric;
        result = 31 * result + (this.letters != null ? this.letters.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.letters + "(" + this.numeric + ")";
    }

    public static PngChunkCode from(int code) {
        switch (code) {
            case 1229472850: {
                return IHDR;
            }
            case 1732332865: {
                return gAMA;
            }
            case 1649100612: {
                return bKGD;
            }
            case 1951551059: {
                return tRNS;
            }
            case 1229209940: {
                return IDAT;
            }
            case 1229278788: {
                return IEND;
            }
            case 1633899596: {
                return acTL;
            }
            case 1717846356: {
                return fdAT;
            }
        }
        byte[] s = new byte[]{(byte)((code & 0xFF000000) >> 24), (byte)((code & 0xFF0000) >> 16), (byte)((code & 0xFF00) >> 8), (byte)(code & 0xFF)};
        return new PngChunkCode(code, new String(s));
    }
}

