/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.chunks;

import de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.PngColourType;
import de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.chunks.PngFrameControl;
import de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.error.PngException;
import de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.error.PngFeatureException;
import de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.error.PngIntegrityException;
import de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.reader.PngReadHelper;
import java.io.DataInput;
import java.io.IOException;

public class PngHeader {
    public final int width;
    public final int height;
    public final byte bitDepth;
    public final PngColourType colourType;
    public final byte compressionMethod;
    public final byte filterMethod;
    public final byte interlaceMethod;
    public final int bitsPerPixel;
    public final int bytesPerRow;
    public final int filterOffset;

    public PngHeader(int width, int height, byte bitDepth, PngColourType colourType) {
        this(width, height, bitDepth, colourType, 0, 0, 0);
    }

    public PngHeader(int width, int height, byte bitDepth, PngColourType colourType, byte compressionMethod, byte filterMethod, byte interlaceMethod) {
        this.width = width;
        this.height = height;
        this.bitDepth = bitDepth;
        this.colourType = colourType;
        this.compressionMethod = compressionMethod;
        this.filterMethod = filterMethod;
        this.interlaceMethod = interlaceMethod;
        this.bitsPerPixel = bitDepth * colourType.componentsPerPixel;
        this.bytesPerRow = PngReadHelper.calculateBytesPerRow(width, bitDepth, colourType, interlaceMethod);
        this.filterOffset = this.bitsPerPixel + 7 >> 3;
    }

    public String toString() {
        return "PngHeader{width=" + this.width + ", height=" + this.height + ", bitDepth=" + this.bitDepth + ", colourType=" + (Object)((Object)this.colourType) + ", compressionMethod=" + this.compressionMethod + ", filterMethod=" + this.filterMethod + ", interlaceMethod=" + this.interlaceMethod + '}';
    }

    public boolean isInterlaced() {
        return this.interlaceMethod == 1;
    }

    public boolean isZipCompression() {
        return this.compressionMethod == 0;
    }

    public boolean isGreyscale() {
        return this.colourType == PngColourType.PNG_GREYSCALE | this.colourType == PngColourType.PNG_GREYSCALE_WITH_ALPHA;
    }

    public boolean hasAlphaChannel() {
        return this.colourType == PngColourType.PNG_GREYSCALE_WITH_ALPHA | this.colourType == PngColourType.PNG_TRUECOLOUR_WITH_ALPHA;
    }

    public static PngHeader makeTruecolour(int width, int height) {
        return new PngHeader(width, height, 8, PngColourType.PNG_TRUECOLOUR);
    }

    public static PngHeader makeTruecolourAlpha(int width, int height) {
        return new PngHeader(width, height, 8, PngColourType.PNG_TRUECOLOUR_WITH_ALPHA);
    }

    public PngHeader adjustFor(PngFrameControl frame) {
        if (frame == null) {
            return this;
        }
        return new PngHeader(frame.width, frame.height, this.bitDepth, this.colourType, this.compressionMethod, this.filterMethod, this.interlaceMethod);
    }

    public static void checkHeaderParameters(int width, int height, byte bitDepth, PngColourType colourType, byte compressionMethod, byte filterMethod, byte interlaceMethod) throws PngException {
        switch (bitDepth) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                break;
            }
            default: {
                throw new PngIntegrityException("Invalid bit depth " + bitDepth);
            }
        }
        if (colourType.isIndexed() && bitDepth > 8) {
            throw new PngIntegrityException(String.format("Indexed images (colour type %d) cannot have bitdepth > 8 (bit depth %d). See http://www.w3.org/TR/2003/REC-PNG-20031110/#table111 .", colourType.code, bitDepth));
        }
        if (bitDepth < 8 && !colourType.supportsSubByteDepth()) {
            throw new PngIntegrityException(String.format("Illegal combination of bit depth (%d) and colour type (%d). See http://www.w3.org/TR/2003/REC-PNG-20031110/#table111 .", colourType.code, bitDepth));
        }
        if (interlaceMethod != 0) {
            throw new PngFeatureException("Interlaced images are not yet supported");
        }
    }

    public static PngHeader from(DataInput dis) throws IOException, PngException {
        int width = dis.readInt();
        int height = dis.readInt();
        byte bitDepth = dis.readByte();
        PngColourType colourType = PngColourType.fromByte(dis.readByte());
        byte compressionMethod = dis.readByte();
        byte filterMethod = dis.readByte();
        byte interlaceMethod = dis.readByte();
        PngHeader.checkHeaderParameters(width, height, bitDepth, colourType, compressionMethod, filterMethod, interlaceMethod);
        return new PngHeader(width, height, bitDepth, colourType, compressionMethod, filterMethod, interlaceMethod);
    }
}

