/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.earlywindow.window.texture;

import de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.Png;
import de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.argb8888.Argb8888Bitmap;
import de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.argb8888.Argb8888BitmapSequence;
import de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.chunks.PngAnimationControl;
import de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.chunks.PngFrameControl;
import de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.error.PngException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public final class EarlyWindowTextureLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long DEFAULT_FRAME_DURATION_NANOS = 100000000L;
    private static final int APNG_DISPOSE_NONE = 0;
    private static final int APNG_DISPOSE_BACKGROUND = 1;
    private static final int APNG_DISPOSE_PREVIOUS = 2;
    private static final int APNG_BLEND_OVER = 1;
    private final Path gameDirectory;
    private final ClassLoader resourceLoader;

    public EarlyWindowTextureLoader(Path gameDirectory, ClassLoader resourceLoader) {
        this.gameDirectory = gameDirectory;
        this.resourceLoader = resourceLoader != null ? resourceLoader : EarlyWindowTextureLoader.class.getClassLoader();
    }

    public LoadedTexture loadUserTexture(String configuredPath, boolean supportApng) {
        LoadedTexture animated;
        Path resolved = this.resolveTexturePath(configuredPath);
        if (resolved == null) {
            return null;
        }
        if (supportApng && (animated = this.loadApngTexture(resolved)) != null) {
            return animated;
        }
        return this.uploadTextureFromPath(resolved);
    }

    public LoadedTexture loadTextureFromBytes(byte[] data, boolean supportApng, String label) {
        LoadedTexture animated;
        if (data == null || data.length == 0) {
            return null;
        }
        if (supportApng && (animated = this.loadApngTexture(data, label)) != null) {
            return animated;
        }
        return this.uploadTextureFromBytes(data, label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public LoadedTexture loadBundledTexture(String resourcePath) {
        if (resourcePath == null || resourcePath.isBlank()) {
            return null;
        }
        try (InputStream stream = this.resourceLoader.getResourceAsStream(resourcePath);){
            LoadedTexture loadedTexture;
            if (stream == null) {
                LOGGER.warn("[DRIPPY LOADING SCREEN] Unable to locate bundled texture at {}", (Object)resourcePath);
                LoadedTexture loadedTexture2 = null;
                return loadedTexture2;
            }
            byte[] data = stream.readAllBytes();
            ByteBuffer buffer = MemoryUtil.memAlloc((int)data.length);
            buffer.put(data).flip();
            try {
                loadedTexture = this.decodeTexture(buffer, resourcePath);
            }
            catch (Throwable throwable) {
                MemoryUtil.memFree((Buffer)buffer);
                throw throwable;
            }
            MemoryUtil.memFree((Buffer)buffer);
            return loadedTexture;
        }
        catch (IOException e) {
            LOGGER.warn("[DRIPPY LOADING SCREEN] Failed to load bundled texture resource {}", (Object)resourcePath, (Object)e);
            return null;
        }
    }

    private LoadedTexture loadApngTexture(Path path) {
        LoadedTexture loadedTexture;
        BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
        try {
            loadedTexture = this.decodeApng(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (PngException | IOException | RuntimeException ex) {
                LOGGER.warn("[DRIPPY LOADING SCREEN] Failed to decode APNG texture {}: {}", (Object)path, (Object)ex.getMessage());
                LOGGER.debug("[DRIPPY LOADING SCREEN] Detailed APNG decode failure for {}", (Object)path, (Object)ex);
                return null;
            }
        }
        ((InputStream)stream).close();
        return loadedTexture;
    }

    private LoadedTexture loadApngTexture(byte[] data, String label) {
        LoadedTexture loadedTexture;
        BufferedInputStream stream = new BufferedInputStream(new ByteArrayInputStream(data));
        try {
            loadedTexture = this.decodeApng(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (PngException | IOException | RuntimeException ex) {
                LOGGER.warn("[DRIPPY LOADING SCREEN] Failed to decode APNG texture {}: {}", (Object)label, (Object)ex.getMessage());
                LOGGER.debug("[DRIPPY LOADING SCREEN] Detailed APNG decode failure for {}", (Object)label, (Object)ex);
                return null;
            }
        }
        ((InputStream)stream).close();
        return loadedTexture;
    }

    private LoadedTexture uploadApngSequence(Argb8888BitmapSequence sequence) {
        List<Argb8888BitmapSequence.Frame> animationFrames;
        int width = Math.max(1, sequence.header.width);
        int height = Math.max(1, sequence.header.height);
        ArrayList<TextureFrame> frames = new ArrayList<TextureFrame>();
        int[] working = new int[width * height];
        if (sequence.hasDefaultImage() && sequence.defaultImage != null) {
            int[] defaultPixels = sequence.defaultImage.getPixelArray();
            System.arraycopy(defaultPixels, 0, working, 0, Math.min(defaultPixels.length, working.length));
            frames.add(this.createFrameFromPixels(working, width, height, 100000000L));
        }
        if ((animationFrames = sequence.getAnimationFrames()) == null || animationFrames.isEmpty()) {
            if (frames.isEmpty()) {
                return null;
            }
            TextureFrame single = (TextureFrame)frames.get(0);
            return LoadedTexture.singleFrame(single.textureId(), width, height);
        }
        for (Argb8888BitmapSequence.Frame frame : animationFrames) {
            PngFrameControl control = frame.control;
            if (control == null || frame.bitmap == null) continue;
            int[] snapshot = control.disposeOp == 2 ? Arrays.copyOf(working, working.length) : null;
            this.blendFrameOnto(working, frame.bitmap, control, width, height);
            long duration = this.toFrameDurationNanos(control.getDelayMilliseconds());
            frames.add(this.createFrameFromPixels(working, width, height, duration));
            this.applyDisposal(working, snapshot, control, width, height);
        }
        if (frames.isEmpty()) {
            return null;
        }
        if (frames.size() == 1) {
            TextureFrame single = (TextureFrame)frames.get(0);
            return LoadedTexture.singleFrame(single.textureId(), width, height);
        }
        int loopCount = this.extractLoopCount(sequence.getAnimationControl());
        return LoadedTexture.animated(frames, width, height, loopCount);
    }

    private void blendFrameOnto(int[] canvas, Argb8888Bitmap bitmap, PngFrameControl control, int canvasWidth, int canvasHeight) {
        int destX = this.clampInt(control.xOffset, 0, Math.max(0, canvasWidth - 1));
        int destY = this.clampInt(control.yOffset, 0, Math.max(0, canvasHeight - 1));
        int availableWidth = canvasWidth - destX;
        int availableHeight = canvasHeight - destY;
        int copyWidth = Math.min(Math.min(bitmap.getWidth(), control.width), Math.max(0, availableWidth));
        int copyHeight = Math.min(Math.min(bitmap.getHeight(), control.height), Math.max(0, availableHeight));
        if (copyWidth <= 0 || copyHeight <= 0) {
            return;
        }
        int[] srcPixels = bitmap.getPixelArray();
        int srcStride = bitmap.getWidth();
        boolean blendOver = control.blendOp == 1;
        for (int row = 0; row < copyHeight; ++row) {
            int destIndex = (destY + row) * canvasWidth + destX;
            int srcIndex = row * srcStride;
            for (int col = 0; col < copyWidth; ++col) {
                int srcPixel = srcPixels[srcIndex + col];
                canvas[destIndex + col] = !blendOver ? srcPixel : this.blendOver(canvas[destIndex + col], srcPixel);
            }
        }
    }

    private void applyDisposal(int[] canvas, int[] previous, PngFrameControl control, int canvasWidth, int canvasHeight) {
        block5: {
            int regionHeight;
            int regionWidth;
            int destY;
            int destX;
            block4: {
                if (control.disposeOp == 0) {
                    return;
                }
                destX = this.clampInt(control.xOffset, 0, Math.max(0, canvasWidth - 1));
                destY = this.clampInt(control.yOffset, 0, Math.max(0, canvasHeight - 1));
                regionWidth = Math.min(control.width, Math.max(0, canvasWidth - destX));
                regionHeight = Math.min(control.height, Math.max(0, canvasHeight - destY));
                if (regionWidth <= 0 || regionHeight <= 0) {
                    return;
                }
                if (control.disposeOp != 1) break block4;
                for (int row = 0; row < regionHeight; ++row) {
                    int index = (destY + row) * canvasWidth + destX;
                    Arrays.fill(canvas, index, index + regionWidth, 0);
                }
                break block5;
            }
            if (control.disposeOp != 2 || previous == null) break block5;
            for (int row = 0; row < regionHeight; ++row) {
                int index = (destY + row) * canvasWidth + destX;
                System.arraycopy(previous, index, canvas, index, regionWidth);
            }
        }
    }

    private long toFrameDurationNanos(int delayMs) {
        long clamped = Math.max(0, delayMs);
        if (clamped == 0L) {
            return 100000000L;
        }
        return clamped * 1000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextureFrame createFrameFromPixels(int[] pixels, int width, int height, long durationNanos) {
        int[] snapshot = Arrays.copyOf(pixels, pixels.length);
        ByteBuffer buffer = this.toRgbaBuffer(snapshot);
        try {
            int textureId = this.createGlTexture(buffer, width, height);
            long sanitizedDuration = durationNanos <= 0L ? 100000000L : durationNanos;
            TextureFrame textureFrame = new TextureFrame(textureId, sanitizedDuration);
            return textureFrame;
        }
        finally {
            MemoryUtil.memFree((Buffer)buffer);
        }
    }

    private ByteBuffer toRgbaBuffer(int[] argbPixels) {
        ByteBuffer buffer = MemoryUtil.memAlloc((int)(argbPixels.length * 4));
        for (int pixel : argbPixels) {
            buffer.put((byte)(pixel >> 16 & 0xFF));
            buffer.put((byte)(pixel >> 8 & 0xFF));
            buffer.put((byte)(pixel & 0xFF));
            buffer.put((byte)(pixel >>> 24 & 0xFF));
        }
        buffer.flip();
        return buffer;
    }

    private int extractLoopCount(PngAnimationControl control) {
        if (control == null) {
            return -1;
        }
        return control.loopForever() ? -1 : Math.max(1, control.numPlays);
    }

    private int blendOver(int dstPixel, int srcPixel) {
        int srcAlpha = srcPixel >>> 24 & 0xFF;
        if (srcAlpha == 0) {
            return dstPixel;
        }
        float srcA = (float)srcAlpha / 255.0f;
        int dstAlpha = dstPixel >>> 24 & 0xFF;
        float dstA = (float)dstAlpha / 255.0f;
        float outA = srcA + dstA * (1.0f - srcA);
        if (outA <= 0.0f) {
            return 0;
        }
        int srcR = srcPixel >>> 16 & 0xFF;
        int srcG = srcPixel >>> 8 & 0xFF;
        int srcB = srcPixel & 0xFF;
        int dstR = dstPixel >>> 16 & 0xFF;
        int dstG = dstPixel >>> 8 & 0xFF;
        int dstB = dstPixel & 0xFF;
        int outR = this.clampChannel(Math.round(((float)srcR * srcA + (float)dstR * dstA * (1.0f - srcA)) / outA));
        int outG = this.clampChannel(Math.round(((float)srcG * srcA + (float)dstG * dstA * (1.0f - srcA)) / outA));
        int outB = this.clampChannel(Math.round(((float)srcB * srcA + (float)dstB * dstA * (1.0f - srcA)) / outA));
        int outAlpha = this.clampChannel(Math.round(outA * 255.0f));
        return outAlpha << 24 | outR << 16 | outG << 8 | outB;
    }

    private int clampChannel(int value) {
        return Math.max(0, Math.min(255, value));
    }

    private Path resolveTexturePath(String configuredPath) {
        if (configuredPath == null || configuredPath.isBlank() || this.gameDirectory == null) {
            return null;
        }
        String trimmed = configuredPath.trim();
        try {
            Path candidate;
            if (trimmed.startsWith("/") || trimmed.startsWith("\\")) {
                candidate = this.gameDirectory.resolve(trimmed.substring(1));
            } else {
                Path raw = Paths.get(trimmed, new String[0]);
                Path path = candidate = raw.isAbsolute() ? raw : this.gameDirectory.resolve(raw);
            }
            if (!Files.isReadable(candidate)) {
                LOGGER.debug("[DRIPPY LOADING SCREEN] Configured early loading texture {} not found", (Object)candidate);
                return null;
            }
            return candidate.normalize();
        }
        catch (InvalidPathException ex) {
            LOGGER.warn("[DRIPPY LOADING SCREEN] Invalid early loading texture path '{}'", (Object)configuredPath, (Object)ex);
            return null;
        }
    }

    private LoadedTexture decodeApng(InputStream stream) throws IOException, PngException {
        Argb8888BitmapSequence sequence = Png.readArgb8888BitmapSequence(stream);
        if (sequence == null || !sequence.isAnimated()) {
            return null;
        }
        return this.uploadApngSequence(sequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadedTexture uploadTextureFromPath(Path path) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            LoadedTexture loadedTexture;
            IntBuffer width = stack.mallocInt(1);
            IntBuffer height = stack.mallocInt(1);
            IntBuffer channels = stack.mallocInt(1);
            ByteBuffer image = STBImage.stbi_load((CharSequence)path.toString(), (IntBuffer)width, (IntBuffer)height, (IntBuffer)channels, (int)4);
            if (image == null) {
                LOGGER.warn("[DRIPPY LOADING SCREEN] Failed to decode texture {}: {}", (Object)path, (Object)STBImage.stbi_failure_reason());
                LoadedTexture loadedTexture2 = null;
                return loadedTexture2;
            }
            try {
                int textureId = this.createGlTexture(image, width.get(0), height.get(0));
                loadedTexture = LoadedTexture.singleFrame(textureId, width.get(0), height.get(0));
            }
            catch (Throwable throwable) {
                STBImage.stbi_image_free((ByteBuffer)image);
                throw throwable;
            }
            STBImage.stbi_image_free((ByteBuffer)image);
            return loadedTexture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadedTexture uploadTextureFromBytes(byte[] data, String label) {
        ByteBuffer buffer = MemoryUtil.memAlloc((int)data.length);
        buffer.put(data).flip();
        try {
            LoadedTexture loadedTexture = this.decodeTexture(buffer, label);
            return loadedTexture;
        }
        finally {
            MemoryUtil.memFree((Buffer)buffer);
        }
    }

    private int createGlTexture(ByteBuffer image, int width, int height) {
        int textureId = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)textureId);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)image);
        GL11.glBindTexture((int)3553, (int)0);
        return textureId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadedTexture decodeTexture(ByteBuffer buffer, String label) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            LoadedTexture loadedTexture;
            IntBuffer width = stack.mallocInt(1);
            IntBuffer height = stack.mallocInt(1);
            IntBuffer channels = stack.mallocInt(1);
            ByteBuffer image = STBImage.stbi_load_from_memory((ByteBuffer)buffer, (IntBuffer)width, (IntBuffer)height, (IntBuffer)channels, (int)4);
            if (image == null) {
                LOGGER.warn("[DRIPPY LOADING SCREEN] Failed to decode texture {}: {}", (Object)label, (Object)STBImage.stbi_failure_reason());
                LoadedTexture loadedTexture2 = null;
                return loadedTexture2;
            }
            try {
                int textureId = this.createGlTexture(image, width.get(0), height.get(0));
                loadedTexture = LoadedTexture.singleFrame(textureId, width.get(0), height.get(0));
            }
            catch (Throwable throwable) {
                STBImage.stbi_image_free((ByteBuffer)image);
                throw throwable;
            }
            STBImage.stbi_image_free((ByteBuffer)image);
            return loadedTexture;
        }
    }

    private int clampInt(int value, int min, int max) {
        if (max < min) {
            return min;
        }
        return Math.max(min, Math.min(value, max));
    }

    public static final class LoadedTexture {
        private final TextureFrame[] frames;
        private final int width;
        private final int height;
        private final boolean loopsForever;
        private final int loopLimit;
        private final boolean animated;
        private int currentFrameIndex;
        private long frameStartedAtNanos;
        private int completedLoops;
        private boolean animationFinished;

        private LoadedTexture(TextureFrame[] frames, int width, int height, int loopLimit) {
            this.frames = frames;
            this.width = width;
            this.height = height;
            this.loopLimit = Math.max(0, loopLimit);
            this.loopsForever = loopLimit <= 0;
            this.animated = frames.length > 1;
        }

        private static LoadedTexture singleFrame(int textureId, int width, int height) {
            return new LoadedTexture(new TextureFrame[]{new TextureFrame(textureId, 0L)}, width, height, 0);
        }

        private static LoadedTexture animated(List<TextureFrame> frameList, int width, int height, int loopLimit) {
            TextureFrame[] array = (TextureFrame[])frameList.toArray(TextureFrame[]::new);
            return new LoadedTexture(array, width, height, loopLimit);
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public int currentTextureId(long nowNanos) {
            if (this.frames.length == 0) {
                return 0;
            }
            if (!this.animated || this.animationFinished) {
                if (this.frameStartedAtNanos == 0L) {
                    this.frameStartedAtNanos = nowNanos;
                }
                return this.frames[this.currentFrameIndex].textureId();
            }
            if (this.frameStartedAtNanos == 0L) {
                this.frameStartedAtNanos = nowNanos;
                return this.frames[this.currentFrameIndex].textureId();
            }
            long frameDuration = this.frameDuration(this.frames[this.currentFrameIndex]);
            while (nowNanos - this.frameStartedAtNanos >= frameDuration && !this.animationFinished) {
                this.frameStartedAtNanos += frameDuration;
                this.advanceFrame();
                frameDuration = this.frameDuration(this.frames[this.currentFrameIndex]);
            }
            return this.frames[this.currentFrameIndex].textureId();
        }

        private long frameDuration(TextureFrame frame) {
            long duration = frame.durationNanos();
            return duration <= 0L ? 100000000L : duration;
        }

        private void advanceFrame() {
            if (this.frames.length <= 1) {
                return;
            }
            ++this.currentFrameIndex;
            if (this.currentFrameIndex >= this.frames.length) {
                if (this.loopsForever) {
                    this.currentFrameIndex = 0;
                } else {
                    ++this.completedLoops;
                    if (this.completedLoops >= this.loopLimit) {
                        this.animationFinished = true;
                        this.currentFrameIndex = this.frames.length - 1;
                    } else {
                        this.currentFrameIndex = 0;
                    }
                }
            }
        }

        public void delete() {
            for (TextureFrame frame : this.frames) {
                GL11.glDeleteTextures((int)frame.textureId());
            }
        }
    }

    private record TextureFrame(int textureId, long durationNanos) {
    }
}

