/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.hhamsters.blocks.pixel_placement.util;

import com.dragn0007.hhamsters.blocks.pixel_placement.util.PixelPlacer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class PixelPlacerData {
    public Vec3 pos;
    public Direction dir;
    public PixelPlacer pixelPlacer;

    public PixelPlacerData(Vec3 pos, Direction dir, PixelPlacer pixelPlacer) {
        this.pos = pos;
        this.dir = dir;
        this.pixelPlacer = pixelPlacer;
    }

    public static CompoundTag pack(PixelPlacerData pixelPlacerData) {
        CompoundTag tag = new CompoundTag();
        long x = Math.round(pixelPlacerData.pos.f_82479_ * 16.0) & 0xFL;
        long y = Math.round(pixelPlacerData.pos.f_82480_ * 16.0) & 0xFL;
        long z = Math.round(pixelPlacerData.pos.f_82481_ * 16.0) & 0xFL;
        long offset = x | y << 4 | z << 8;
        String dirName = pixelPlacerData.dir.m_122433_();
        int id = Block.m_49956_((BlockState)pixelPlacerData.pixelPlacer.m_49966_());
        tag.m_128356_("Pos", offset);
        tag.m_128359_("Dir", dirName);
        tag.m_128405_("PixelPlacer", id);
        return tag;
    }

    public static PixelPlacerData unpack(CompoundTag tag) {
        long offset = tag.m_128454_("Pos");
        String dirName = tag.m_128461_("Dir");
        int id = tag.m_128451_("PixelPlacer");
        Vec3 pos = new Vec3((double)(offset & 0xFL) / 16.0, (double)(offset >> 4 & 0xFL) / 16.0, (double)(offset >> 8 & 0xFL) / 16.0);
        Direction dir = Direction.m_122402_((String)dirName);
        PixelPlacer pixelPlacer = (PixelPlacer)Block.m_49803_((int)id).m_60734_();
        return new PixelPlacerData(pos, dir, pixelPlacer);
    }
}

