/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.hhamsters.entities.hamster;

import com.dragn0007.dragnlivestock.entities.util.LOAnimations;
import com.dragn0007.dragnlivestock.items.LOItems;
import com.dragn0007.dragnlivestock.util.LOTags;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import com.dragn0007.hhamsters.entities.ai.HamsterFollowOwnerGoal;
import com.dragn0007.hhamsters.entities.hamster.HamsterMarkingLayer;
import com.dragn0007.hhamsters.entities.hamster.HamsterModel;
import com.dragn0007.hhamsters.entities.util.EntityTypes;
import com.dragn0007.hhamsters.gui.HamsterMenu;
import com.dragn0007.hhamsters.util.HHTags;
import com.dragn0007.hhamsters.util.HamtasticHamstersCommonConfig;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Containers;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Hamster
extends TamableAnimal
implements InventoryCarrier,
GeoEntity,
ContainerListener {
    public static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(HHTags.Items.HAMSTER_FOOD);
    public int fedCounter = 0;
    public int standCounter = this.f_19796_.m_188503_(3600) + 3600;
    public int stayStandingCounter = 0;
    private boolean fed = false;
    private boolean stand = false;
    public boolean toldToWander = false;
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    int moreCropsTicks;
    public static final EntityDataAccessor<String> VARIANT_TEXTURE = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> OVERLAY_TEXTURE = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> BREED = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(Hamster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public SimpleContainer inventory;
    public LazyOptional<?> itemHandler = null;
    static final Predicate<ItemEntity> HAMSTER_SEEKS = itemEntity -> !itemEntity.m_32063_() && itemEntity.m_6084_() && itemEntity.m_32055_().m_204117_(HHTags.Items.HAMSTER_SEEKS);

    public Hamster(EntityType<? extends Hamster> type, Level level) {
        super(type, level);
        this.m_7105_(false);
        this.updateInventory();
        this.m_21553_(true);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * (double)0.6f, (double)(this.m_20205_() * 0.6f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22279_, (double)0.17f).m_22268_(Attributes.f_22281_, 0.5);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, true));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 2.0f));
        this.f_21345_.m_25352_(3, (Goal)new HamsterSearchForItemsGoal());
        this.f_21345_.m_25352_(3, (Goal)new PickCropsGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new HamsterFollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 15.0f, (double)1.8f, (double)1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.WOLVES) && livingEntity instanceof TamableAnimal && !((TamableAnimal)livingEntity).m_21824_() && !this.m_21824_()));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 15.0f, (double)1.8f, (double)1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.CATS) && livingEntity instanceof TamableAnimal && !((TamableAnimal)livingEntity).m_21824_() && !this.m_21824_()));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 15.0f, (double)1.8f, (double)1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.DOGS) && livingEntity instanceof TamableAnimal && !((TamableAnimal)livingEntity).m_21824_() && !this.m_21824_()));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 15.0f, (double)1.8f, (double)1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.FOXES) && livingEntity instanceof TamableAnimal && !((TamableAnimal)livingEntity).m_21824_() && !this.m_21824_()));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 15.0f, (double)1.8f, (double)1.8f, livingEntity -> livingEntity instanceof PolarBear && !this.m_21824_()));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 15.0f, (double)1.8f, (double)1.8f, livingEntity -> livingEntity instanceof Panda && !this.m_21824_()));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 15.0f, (double)1.8f, (double)1.8f, livingEntity -> livingEntity instanceof Villager && !this.m_21824_()));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 15.0f, (double)1.8f, (double)1.8f, livingEntity -> livingEntity instanceof Player && !this.m_21824_() && livingEntity.m_6047_()));
        this.f_21345_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 2, true, false, entity -> entity instanceof Hamster && (Boolean)HamtasticHamstersCommonConfig.HAMSTERS_FIGHT.get() != false && this.m_21824_() && !this.m_6162_() && !entity.m_6162_() && ((Hamster)((Object)entity)).m_21824_() && ((Hamster)((Object)entity)).getGender() == this.getGender()));
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        Entity entity = damageSource.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!(this.m_9236_().f_46443_ || !this.m_21824_() || this.m_21827_() || this.m_21825_() || this.wasToldToWander())) {
                if (this.m_21830_((LivingEntity)player) && player.m_6144_()) {
                    this.setToldToWander(true);
                    player.m_5661_((Component)Component.m_237115_((String)"tooltip.hhamsters.wandering.tooltip").m_130940_(ChatFormatting.GOLD), true);
                }
                return false;
            }
            if (!this.m_9236_().f_46443_ && this.m_21824_() && !this.m_21827_() && !this.m_21825_() && this.wasToldToWander()) {
                if (this.m_21830_((LivingEntity)player) && player.m_6144_()) {
                    this.setToldToWander(false);
                    player.m_5661_((Component)Component.m_237115_((String)"tooltip.hhamsters.following.tooltip").m_130940_(ChatFormatting.GOLD), true);
                }
                return false;
            }
        }
        return super.m_6469_(damageSource, amount);
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.fedCounter;
        if (this.fedCounter >= 2400) {
            this.setFed(false);
        }
        --this.standCounter;
        if (this.isStanding()) {
            this.f_21344_.m_26573_();
        }
        if (--this.standCounter <= 0) {
            ++this.stayStandingCounter;
            this.setStanding(true);
            if (this.stayStandingCounter >= 150) {
                this.standCounter = this.f_19796_.m_188503_(3600) + 3600;
                this.stayStandingCounter = 0;
                this.setStanding(false);
            }
        }
    }

    public boolean isFed() {
        return this.fed;
    }

    public boolean getPlantsSheared() {
        return this.fed;
    }

    public void setFed(boolean fed) {
        this.fed = fed;
    }

    public boolean isStanding() {
        return this.stand;
    }

    public void setStanding(boolean standing) {
        this.stand = standing;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (itemstack.m_150930_((Item)LOItems.COAT_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_() && this.getVariant() > 0) {
                this.setVariant(this.getVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            this.setVariant(this.getVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.MARKING_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_() && this.getOverlayVariant() > 0) {
                this.setOverlayVariant(this.getOverlayVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            this.setOverlayVariant(this.getOverlayVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.BREED_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_() && this.getBreed() > 0) {
                this.setBreed(this.getBreed() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            Breed currentBreed = Breed.values()[this.getBreed()];
            Breed nextBreed = currentBreed.next();
            this.setBreed(nextBreed.ordinal());
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isFemale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.FEMALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isMale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.MALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (this.m_21830_((LivingEntity)player) && this.m_21824_() && !this.m_6162_() && this.m_21824_() && player.m_36341_() && player.m_6047_()) {
            this.openInventory(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_21824_() && this.m_6898_(itemstack)) {
            this.setFed(true);
            this.fedCounter = 0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.7, 0.7, 0.7);
            if (this.m_21223_() < this.m_21233_()) {
                this.m_5634_(2.0f);
            }
            int i = this.m_146764_();
            if (!this.m_9236_().f_46443_ && i == 0 && this.m_5957_()) {
                this.m_142075_(player, hand, itemstack);
                this.m_27595_(player);
                return InteractionResult.SUCCESS;
            }
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.m_146850_(GameEvent.f_223708_);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_9236_().f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || this.m_6898_(itemstack) && !this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_6898_(itemstack)) {
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
                }
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                int i = this.m_146764_();
                if (!this.m_9236_().f_46443_ && i == 0 && this.m_5957_()) {
                    this.m_142075_(player, hand, itemstack);
                    this.m_27595_(player);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.SUCCESS;
            }
            if (!this.m_6898_(itemstack)) {
                InteractionResult interactionresult = super.m_6071_(player, hand);
                if ((!interactionresult.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)player)) {
                    this.m_21839_(!this.m_21827_());
                    this.f_20899_ = false;
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    return InteractionResult.SUCCESS;
                }
                return interactionresult;
            }
        } else if (this.m_6898_(itemstack)) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean wasToldToWander() {
        return this.toldToWander;
    }

    public boolean getToldToWander() {
        return this.toldToWander;
    }

    public void setToldToWander(boolean toldToWander) {
        this.toldToWander = toldToWander;
    }

    public float getStepHeight() {
        return 1.0f;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.01;
        AnimationController controller = tAnimationState.getController();
        if (tAnimationState.isMoving()) {
            if (currentSpeed > speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(2.0);
            } else {
                controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.2);
            }
        } else if (this.isStanding()) {
            controller.setAnimation(RawAnimation.begin().then("stand", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(0.8);
        } else if (this.m_21825_()) {
            controller.setAnimation(RawAnimation.begin().then("sploot", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(0.8);
        } else {
            controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(0.8);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
        controllers.add(new AnimationController[]{LOAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)LOAnimations.ATTACK)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public SoundEvent m_7515_() {
        super.m_7515_();
        return SoundEvents.f_12297_;
    }

    public SoundEvent m_5592_() {
        super.m_5592_();
        return SoundEvents.f_12352_;
    }

    public SoundEvent m_7975_(DamageSource p_30720_) {
        super.m_7975_(p_30720_);
        return SoundEvents.f_12353_;
    }

    public void m_7355_(BlockPos p_28254_, BlockState p_28255_) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    public String getTextureResource() {
        return (String)this.f_19804_.m_135370_(VARIANT_TEXTURE);
    }

    public String getOverlayLocation() {
        return (String)this.f_19804_.m_135370_(OVERLAY_TEXTURE);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public int getOverlayVariant() {
        return (Integer)this.f_19804_.m_135370_(OVERLAY);
    }

    public int getBreed() {
        return (Integer)this.f_19804_.m_135370_(BREED);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
        this.f_19804_.m_135381_(VARIANT_TEXTURE, (Object)HamsterModel.Variant.variantFromOrdinal((int)variant).resourceLocation.toString());
    }

    public void setOverlayVariant(int overlayVariant) {
        this.f_19804_.m_135381_(OVERLAY, (Object)overlayVariant);
        this.f_19804_.m_135381_(OVERLAY_TEXTURE, (Object)HamsterMarkingLayer.Overlay.patternFromOrdinal((int)overlayVariant).resourceLocation.toString());
    }

    public void setVariantTexture(String variant) {
        this.f_19804_.m_135381_(VARIANT_TEXTURE, (Object)variant);
    }

    public void setOverlayVariantTexture(String variant) {
        this.f_19804_.m_135381_(OVERLAY_TEXTURE, (Object)variant);
    }

    public void setBreed(int breed) {
        this.f_19804_.m_135381_(BREED, (Object)breed);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Variant_Texture")) {
            this.setVariantTexture(tag.m_128461_("Variant_Texture"));
        }
        if (tag.m_128441_("Overlay_Texture")) {
            this.setOverlayVariantTexture(tag.m_128461_("Overlay_Texture"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        if (tag.m_128441_("Breed")) {
            this.setBreed(tag.m_128451_("Breed"));
        }
        if (tag.m_128441_("Wandering")) {
            this.setToldToWander(tag.m_128471_("Wandering"));
        }
        if (tag.m_128441_("Fed")) {
            this.setFed(tag.m_128471_("Fed"));
        }
        this.updateInventory();
        if (this.m_21824_()) {
            ListTag listTag = tag.m_128437_("Items", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundTag = listTag.m_128728_(i);
                int j = compoundTag.m_128445_("Slot") & 0xFF;
                if (j >= this.inventory.m_6643_()) continue;
                this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundTag));
            }
        }
        this.m_21553_(true);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128359_("Variant_Texture", this.getTextureResource().toString());
        tag.m_128359_("Overlay_Texture", this.getOverlayLocation().toString());
        tag.m_128405_("Gender", this.getGender());
        tag.m_128405_("Breed", this.getBreed());
        tag.m_128379_("Wandering", this.getToldToWander());
        tag.m_128379_("Fed", this.getPlantsSheared());
        if (this.m_21824_()) {
            ListTag listTag = new ListTag();
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemStack = this.inventory.m_8020_(i);
                if (itemStack.m_41619_()) continue;
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.m_128344_("Slot", (byte)i);
                itemStack.m_41739_(compoundTag);
                listTag.add((Object)compoundTag);
            }
            tag.m_128365_("Items", (Tag)listTag);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setVariant(random.nextInt(HamsterModel.Variant.values().length));
        this.setOverlayVariant(random.nextInt(HamsterMarkingLayer.Overlay.values().length));
        this.setGender(random.nextInt(Gender.values().length));
        this.setBreed(random.nextInt(Breed.values().length));
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(BREED, (Object)0);
        this.f_19804_.m_135372_(VARIANT_TEXTURE, (Object)HamsterModel.Variant.BLACK.resourceLocation.toString());
        this.f_19804_.m_135372_(OVERLAY_TEXTURE, (Object)HamsterMarkingLayer.Overlay.NONE.resourceLocation.toString());
    }

    public boolean isFemale() {
        return this.getGender() == 0;
    }

    public boolean isMale() {
        return this.getGender() == 1;
    }

    public int getGender() {
        return (Integer)this.f_19804_.m_135370_(GENDER);
    }

    public void setGender(int gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    public boolean canParent() {
        return !this.m_6162_() && this.m_27593_();
    }

    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (!(animal instanceof Hamster)) {
            return false;
        }
        if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue()) {
            return this.canParent() && ((Hamster)animal).canParent();
        }
        Hamster partner = (Hamster)animal;
        if (this.canParent() && partner.canParent() && this.getGender() != partner.getGender()) {
            return this.isFemale();
        }
        return false;
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        Hamster hamster = (Hamster)ageableMob;
        if (ageableMob instanceof Hamster) {
            Hamster hamster1 = (Hamster)ageableMob;
            hamster = (Hamster)((EntityType)EntityTypes.HAMSTER_ENTITY.get()).m_20615_((Level)serverLevel);
            int i = this.f_19796_.m_188503_(9);
            int variant = i < 4 ? this.getVariant() : (i < 8 ? hamster1.getVariant() : this.f_19796_.m_188503_(HamsterModel.Variant.values().length));
            int j = this.f_19796_.m_188503_(5);
            int overlay = j < 2 ? this.getOverlayVariant() : (j < 4 ? hamster1.getOverlayVariant() : this.f_19796_.m_188503_(HamsterMarkingLayer.Overlay.values().length));
            int k = this.f_19796_.m_188503_(5);
            int breed = k < 2 ? this.getOverlayVariant() : (k < 4 ? hamster1.getOverlayVariant() : this.f_19796_.m_188503_(Breed.values().length));
            int gender = this.f_19796_.m_188503_(Gender.values().length);
            hamster.setVariant(variant);
            hamster.setOverlayVariant(overlay);
            hamster.setGender(gender);
            hamster.setBreed(breed);
        }
        return hamster;
    }

    public void updateInventory() {
        SimpleContainer tempInventory = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (tempInventory != null) {
            tempInventory.m_19181_((ContainerListener)this);
            int maxSize = Math.min(tempInventory.m_6643_(), this.inventory.m_6643_());
            for (int i = 0; i < maxSize; ++i) {
                ItemStack itemStack = tempInventory.m_8020_(i);
                if (itemStack.m_41619_()) continue;
                this.inventory.m_6836_(i, itemStack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    public void m_5907_() {
        if (!this.m_9236_().f_46443_) {
            super.m_5907_();
            Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this.inventory);
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public int getInventorySize() {
        return 3;
    }

    public SimpleContainer m_35311_() {
        return this.inventory;
    }

    public void openInventory(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.m_21824_()) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((containerId, inventory, p) -> new HamsterMenu(containerId, inventory, (Container)this.inventory, this), this.m_5446_()), data -> {
                    data.writeInt(this.getInventorySize());
                    data.writeInt(this.m_19879_());
                });
            }
        }
    }

    public void m_5757_(Container p_18983_) {
    }

    public boolean hasFullInventory() {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            if (!this.inventory.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public class HamsterSearchForItemsGoal
    extends Goal {
        public HamsterSearchForItemsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (Hamster.this.m_21827_()) {
                return false;
            }
            if (Hamster.this.hasFullInventory()) {
                return false;
            }
            if (Hamster.this.m_5448_() == null && Hamster.this.m_21188_() == null) {
                if (Hamster.this.m_217043_().m_188503_(HamsterSearchForItemsGoal.m_186073_((int)5)) != 0) {
                    return false;
                }
                List list = Hamster.this.m_9236_().m_6443_(ItemEntity.class, Hamster.this.m_20191_().m_82377_(8.0, 8.0, 8.0), HAMSTER_SEEKS);
                return !list.isEmpty();
            }
            return false;
        }

        public void m_8037_() {
            List itemEntities = Hamster.this.m_9236_().m_6443_(ItemEntity.class, Hamster.this.m_20191_().m_82377_(8.0, 8.0, 8.0), HAMSTER_SEEKS);
            if (!itemEntities.isEmpty() && !Hamster.this.hasFullInventory()) {
                ItemEntity itemEntity = (ItemEntity)itemEntities.get(0);
                Hamster.this.m_21573_().m_5624_((Entity)itemEntity, 1.2);
                if (Hamster.this.m_20280_((Entity)itemEntity) < 4.0 && itemEntity.m_32055_().m_204117_(HHTags.Items.HAMSTER_SEEKS)) {
                    this.pickUpItem(itemEntity);
                }
            }
        }

        public void m_8056_() {
            List itemEntities = Hamster.this.m_9236_().m_6443_(ItemEntity.class, Hamster.this.m_20191_().m_82377_(8.0, 8.0, 8.0), HAMSTER_SEEKS);
            if (!itemEntities.isEmpty()) {
                Hamster.this.m_21573_().m_5624_((Entity)itemEntities.get(0), 1.2);
            }
        }

        public void pickUpItem(ItemEntity itemEntity) {
            if (!Hamster.this.hasFullInventory() && itemEntity.m_32055_().m_204117_(HHTags.Items.HAMSTER_SEEKS) && this.m_8036_()) {
                int i;
                ItemStack itemStack = itemEntity.m_32055_();
                for (i = 0; i < Hamster.this.m_35311_().m_6643_(); ++i) {
                    ItemStack inventoryStack = Hamster.this.m_35311_().m_8020_(i);
                    if (inventoryStack.m_41619_() || !inventoryStack.m_150930_(itemStack.m_41720_()) || inventoryStack.m_41613_() >= inventoryStack.m_41741_() || !itemStack.m_204117_(HHTags.Items.HAMSTER_SEEKS)) continue;
                    int j = inventoryStack.m_41741_() - inventoryStack.m_41613_();
                    int k = Math.min(j, itemStack.m_41613_());
                    inventoryStack.m_41769_(k);
                    itemStack.m_41774_(k);
                    if (!itemStack.m_41619_()) continue;
                    itemEntity.m_146870_();
                    break;
                }
                if (!itemStack.m_41619_() && itemStack.m_204117_(HHTags.Items.HAMSTER_SEEKS) && this.m_8036_()) {
                    for (i = 0; i < Hamster.this.m_35311_().m_6643_(); ++i) {
                        if (!Hamster.this.m_35311_().m_8020_(i).m_41619_()) continue;
                        Hamster.this.m_35311_().m_6836_(i, itemStack);
                        itemEntity.m_146870_();
                        break;
                    }
                }
            }
        }
    }

    static class PickCropsGoal
    extends MoveToBlockGoal {
        public final Hamster hamster;
        public boolean wantsToPick;
        public boolean canPick;

        public PickCropsGoal(Hamster hamster) {
            super((PathfinderMob)hamster, (double)0.7f, 16);
            this.hamster = hamster;
        }

        public boolean m_8036_() {
            if (this.f_25600_ <= 0) {
                if (!ForgeEventFactory.getMobGriefingEvent((Level)this.hamster.m_9236_(), (Entity)this.hamster)) {
                    return false;
                }
                this.canPick = false;
                this.wantsToPick = true;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            return this.canPick && super.m_8045_();
        }

        public static Property<Integer> getCropProperty(BlockState state, String propertyName) {
            Block block = state.m_60734_();
            if (block instanceof CropBlock) {
                for (Property prop : state.m_61147_()) {
                    if (!(prop instanceof IntegerProperty) || !prop.m_61708_().equals(propertyName)) continue;
                    return prop;
                }
            }
            return null;
        }

        public void m_8037_() {
            super.m_8037_();
            this.hamster.m_21563_().m_24950_((double)this.f_25602_.m_123341_() + 0.5, (double)(this.f_25602_.m_123342_() + 1), (double)this.f_25602_.m_123343_() + 0.5, 10.0f, (float)this.hamster.m_8132_());
            if (this.m_25625_()) {
                Level level = this.hamster.m_9236_();
                BlockPos blockpos = this.f_25602_.m_7494_();
                BlockState blockstate = level.m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                Property<Integer> age = PickCropsGoal.getCropProperty(blockstate, "age");
                if (this.canPick && block instanceof CropBlock) {
                    blockstate.m_60734_();
                    Block.m_49869_((BlockState)blockstate, (ServerLevel)((ServerLevel)level), (BlockPos)blockpos, null).forEach(stack -> level.m_7967_((Entity)new ItemEntity(level, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5, stack)));
                    level.m_46597_(blockpos, (BlockState)blockstate.m_61124_(age, (Comparable)Integer.valueOf(1)));
                    level.m_46796_(2001, blockpos, Block.m_49956_((BlockState)blockstate));
                }
                this.hamster.moreCropsTicks = 40;
                this.canPick = false;
                this.f_25600_ = 20;
            }
        }

        public boolean m_6465_(LevelReader levelReader, BlockPos blockPos) {
            BlockState blockstate = levelReader.m_8055_(blockPos);
            if (blockstate.m_60713_(Blocks.f_50093_) && this.wantsToPick && !this.canPick && (blockstate = levelReader.m_8055_(blockPos.m_7494_())).m_60734_() instanceof CropBlock && ((CropBlock)blockstate.m_60734_()).m_52307_(blockstate)) {
                this.canPick = true;
                return true;
            }
            return false;
        }
    }

    public static enum Breed {
        SYRIAN(new ResourceLocation("hhamsters", "geo/hamster.geo.json")),
        FLUFFY(new ResourceLocation("hhamsters", "geo/hamster_fluffy.geo.json")),
        DWARF(new ResourceLocation("hhamsters", "geo/hamster_dwarf.geo.json"));

        public final ResourceLocation resourceLocation;

        private Breed(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Breed breedFromOrdinal(int ordinal) {
            return Breed.values()[ordinal % Breed.values().length];
        }

        public Breed next() {
            return Breed.values()[(this.ordinal() + 1) % Breed.values().length];
        }
    }

    public static enum Gender {
        FEMALE,
        MALE;

    }
}

