/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.hhamsters.entities.hamster;

import com.dragn0007.hhamsters.entities.hamster.Hamster;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class HamsterModel
extends DefaultedEntityGeoModel<Hamster> {
    public static final ResourceLocation ANIMATION = new ResourceLocation("hhamsters", "animations/hamster.animation.json");
    public static final ResourceLocation DWARF_ANIMATION = new ResourceLocation("hhamsters", "animations/hamster_dwarf.animation.json");
    public static final ResourceLocation BABY = new ResourceLocation("hhamsters", "textures/hamster/baby/hamster_baby.png");
    public static final Map<String, ResourceLocation> TEXTURE_CACHE = new HashMap<String, ResourceLocation>();

    public HamsterModel() {
        super(new ResourceLocation("hhamsters", "hamster"), true);
    }

    public void setCustomAnimations(Hamster animatable, long instanceId, AnimationState<Hamster> animationState) {
        float maxYaw;
        EntityModelData entityData;
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (neck != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
        if (head != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(head.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            head.setRotY(head.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(Hamster object) {
        return Hamster.Breed.breedFromOrdinal((int)object.getBreed()).resourceLocation;
    }

    public ResourceLocation getTextureResource(Hamster object) {
        if (object.m_6162_()) {
            return BABY;
        }
        return TEXTURE_CACHE.computeIfAbsent(object.getTextureResource(), ResourceLocation::m_135820_);
    }

    public ResourceLocation getAnimationResource(Hamster animatable) {
        if (animatable.getBreed() == 2) {
            return DWARF_ANIMATION;
        }
        return ANIMATION;
    }

    public static enum Variant {
        ALBINO(new ResourceLocation("hhamsters", "textures/hamster/hamster_albino.png")),
        BEIGE(new ResourceLocation("hhamsters", "textures/hamster/hamster_beige.png")),
        BLACK(new ResourceLocation("hhamsters", "textures/hamster/hamster_black.png")),
        BLUE(new ResourceLocation("hhamsters", "textures/hamster/hamster_blue.png")),
        CHOCOLATE(new ResourceLocation("hhamsters", "textures/hamster/hamster_chocolate.png")),
        CREAM(new ResourceLocation("hhamsters", "textures/hamster/hamster_cream.png")),
        GREY(new ResourceLocation("hhamsters", "textures/hamster/hamster_grey.png")),
        LAVENDER(new ResourceLocation("hhamsters", "textures/hamster/hamster_lavender.png")),
        RUST(new ResourceLocation("hhamsters", "textures/hamster/hamster_rust.png")),
        SILVER(new ResourceLocation("hhamsters", "textures/hamster/hamster_silver.png")),
        WHITE(new ResourceLocation("hhamsters", "textures/hamster/hamster_white.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

