package thelm.alloyforgeryjei.recipe;

import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import wraith.alloyforgery.recipe.AlloyForgeRecipe;

public record AlloyForgeRecipeWithOverride(AlloyForgeRecipe recipe, int overrideIndex) {

	public static Stream<AlloyForgeRecipeWithOverride> fromRecipe(AlloyForgeRecipe recipe) {
		return IntStream.rangeClosed(0, recipe.getTierOverrides().size()).
				mapToObj(i -> new AlloyForgeRecipeWithOverride(recipe, i));
	}

	public List<List<class_1799>> getInputs() {
		return recipe.getIngredientsMap().entrySet().stream().
				map(entry -> Arrays.stream(entry.getKey().method_8105()).
						map(s -> s.method_46651(entry.getValue())).
						toList()).
				toList();
	}

	public class_1799 getOutput() {
		if(overrideIndex > 0) {
			List<class_1799> overrideOutputs = recipe.getTierOverrides().values().asList();
			if(overrideIndex <= overrideOutputs.size()) {
				return overrideOutputs.get(overrideIndex - 1);
			}
		}
		return recipe.method_8110();
	}

	public class_2561 getTierComponent() {
		Object tierArg = recipe.getMinForgeTier();
		if(overrideIndex > 0) {
			List<AlloyForgeRecipe.OverrideRange> overrideRanges = recipe.getTierOverrides().keySet().asList();
			if(overrideIndex <= overrideRanges.size()) {
				tierArg = overrideRanges.get(overrideIndex - 1);
			}
		}
		return class_2561.method_43469("container.alloy_forgery.rei.min_tier", tierArg);
	}

	public class_2561 getFuelComponent() {
		return class_2561.method_43469("container.alloy_forgery.rei.fuel_per_tick", recipe.getFuelPerTick());
	}
}
