package thelm.alloyforgeryjei.recipe.category;

import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import thelm.alloyforgeryjei.AlloyForgeryJEI;
import thelm.alloyforgeryjei.recipe.AlloyForgeRecipeWithOverride;
import thelm.jeidrawables.JEIDrawables;
import thelm.jeidrawables.gui.render.BlankDrawable;
import thelm.jeidrawables.gui.render.ResourceDrawable;
import wraith.alloyforgery.AlloyForgery;

public class AlloyForgeCategory implements IRecipeCategory<AlloyForgeRecipeWithOverride> {

	public static final class_2561 TITLE = class_2561.method_43471("container.alloy_forgery.rei.title");

	public static final class_2960 BACKGROUND = AlloyForgery.id("textures/gui/forge_controller.png");
	public static final ResourceDrawable INPUT_SLOT = new ResourceDrawable(BACKGROUND, 208, 0, 18, 18);
	public static final ResourceDrawable INPUT_SLOTS = new ResourceDrawable(BACKGROUND, 42, 41, 92, 38);
	public static final ResourceDrawable FAUCET = new ResourceDrawable(BACKGROUND, 208, 30, 10, 10);
	public static final ResourceDrawable INGOT = new ResourceDrawable(BACKGROUND, 176, 0, 16, 20);

	public final IDrawable background;

	public AlloyForgeCategory() {
		background = new BlankDrawable(getWidth(), getHeight());
	}

	@Override
	public RecipeType<AlloyForgeRecipeWithOverride> getRecipeType() {
		return AlloyForgeryJEI.ALLOY_FORGE;
	}

	@Override
	public class_2561 getTitle() {
		return TITLE;
	}

	@Override
	public IDrawable getBackground() {
		return background;
	}

	@Override
	public int getWidth() {
		return 124;
	}

	@Override
	public int getHeight() {
		return 58;
	}

	@Override
	public IDrawable getIcon() {
		return null;
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, AlloyForgeRecipeWithOverride recipe, IFocusGroup focuses) {
		List<List<class_1799>> inputs = recipe.getInputs();
		for(int i = 0; i < inputs.size(); ++i) {
			int x = 2 + i % 5 * 18;
			int y = 22 + i / 5 * 18;
			builder.addSlot(RecipeIngredientRole.INPUT, x, y).addItemStacks(inputs.get(i)).setBackground(INPUT_SLOT, -1, -1);
		}
		builder.addSlot(RecipeIngredientRole.OUTPUT, 103, 29).addItemStack(recipe.getOutput()).setBackground(JEIDrawables.OUTPUT_SLOT, -5, -5);
	}

	@Override
	public void draw(AlloyForgeRecipeWithOverride recipe, IRecipeSlotsView recipeSlotsView, class_4587 poseStack, double mouseX, double mouseY) {
		INPUT_SLOTS.draw(poseStack, 0, 20);
		FAUCET.draw(poseStack, 101, 0);
		INGOT.draw(poseStack, 105, 3);
		class_327 font = class_310.method_1551().field_1772;
		font.method_30883(poseStack, recipe.getTierComponent(), 2, 0, 0x404040);
		font.method_30883(poseStack, recipe.getFuelComponent(), 2, 10, 0x404040);
	}

	@Override
	public class_2960 getRegistryName(AlloyForgeRecipeWithOverride recipe) {
		return new class_2960("%s/%s".formatted(recipe.recipe().method_8114(), recipe.overrideIndex()));
	}
}
