/*
 * Decompiled with CFR 0.152.
 */
package net.litetex.noway.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.litetex.noway.client.NoWayClient;
import net.litetex.noway.client.config.ClientConfig;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoWayFabricClientInitializer
implements ClientModInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(NoWayFabricClientInitializer.class);
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public void onInitializeClient() {
        ClientConfig config = this.loadConfig();
        NoWayClient.setInstance(new NoWayClient(config, this::saveConfig));
        this.initKeys();
        LOG.debug("Initialized");
    }

    private Path configFilePath() {
        return FabricLoader.getInstance().getConfigDir().resolve("no-way.json5");
    }

    private ClientConfig loadConfig() {
        Path configFilePath = this.configFilePath();
        if (Files.exists(configFilePath, new LinkOption[0])) {
            try {
                return (ClientConfig)this.gson.fromJson(Files.readString(configFilePath), ClientConfig.class);
            }
            catch (IOException ioe) {
                LOG.warn("Failed to read config file", (Throwable)ioe);
            }
        }
        ClientConfig defaultConfig = ClientConfig.createDefault();
        this.saveConfig(defaultConfig);
        return defaultConfig;
    }

    private void saveConfig(ClientConfig config) {
        try {
            Files.writeString(this.configFilePath(), (CharSequence)this.gson.toJson((Object)config), new OpenOption[0]);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Failed to save config", ioe);
        }
    }

    private void initKeys() {
        class_304 kbToggleAlwaysHideLocatorBar = KeyBindingHelper.registerKeyBinding((class_304)new class_304("no-way.toggle-always-hide-locator-bar", class_3675.class_307.field_1668, 299, class_304.class_11900.field_62556));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (kbToggleAlwaysHideLocatorBar.method_1436()) {
                boolean on = NoWayClient.instance().toggleAlwaysHideLocatorBar();
                client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)("no-way.always-hide-locator-bar." + (on ? "on" : "off"))));
            }
        });
    }
}

