/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.apache.hc.client5.http.protocol;

import amp_libs.org.apache.hc.client5.http.config.RequestConfig;
import amp_libs.org.apache.hc.client5.http.protocol.HttpClientContext;
import amp_libs.org.apache.hc.core5.annotation.Contract;
import amp_libs.org.apache.hc.core5.annotation.ThreadingBehavior;
import amp_libs.org.apache.hc.core5.http.EntityDetails;
import amp_libs.org.apache.hc.core5.http.HttpException;
import amp_libs.org.apache.hc.core5.http.HttpRequest;
import amp_libs.org.apache.hc.core5.http.HttpRequestInterceptor;
import amp_libs.org.apache.hc.core5.http.Method;
import amp_libs.org.apache.hc.core5.http.ProtocolVersion;
import amp_libs.org.apache.hc.core5.http.protocol.HttpContext;
import amp_libs.org.apache.hc.core5.util.Args;
import amp_libs.org.slf4j.Logger;
import amp_libs.org.slf4j.LoggerFactory;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.STATELESS)
public final class RequestUpgrade
implements HttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RequestUpgrade.class);

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        HttpClientContext clientContext = HttpClientContext.cast(context);
        RequestConfig requestConfig = clientContext.getRequestConfigOrDefault();
        if (requestConfig.isProtocolUpgradeEnabled()) {
            ProtocolVersion version;
            ProtocolVersion protocolVersion = version = request.getVersion() != null ? request.getVersion() : clientContext.getProtocolVersion();
            if (!request.containsHeader("Upgrade") && !request.containsHeader("Connection") && version.getMajor() == 1 && version.getMinor() >= 1) {
                String method;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Connection is upgradable: protocol version = {}", (Object)version);
                }
                if ((Method.OPTIONS.isSame(method = request.getMethod()) || Method.HEAD.isSame(method) || Method.GET.isSame(method)) && clientContext.getSSLSession() == null) {
                    LOG.debug("Connection is upgradable to TLS: method = {}", (Object)method);
                    request.addHeader("Upgrade", "TLS/1.2");
                    request.addHeader("Connection", "Upgrade");
                }
            }
        }
    }
}

