/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.asn1.bc;

import amp_libs.org.bouncycastle.asn1.ASN1Object;
import amp_libs.org.bouncycastle.asn1.ASN1OctetString;
import amp_libs.org.bouncycastle.asn1.ASN1Primitive;
import amp_libs.org.bouncycastle.asn1.ASN1Sequence;
import amp_libs.org.bouncycastle.asn1.DEROctetString;
import amp_libs.org.bouncycastle.asn1.DERSequence;
import amp_libs.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import amp_libs.org.bouncycastle.util.Arrays;

public class EncryptedObjectStoreData
extends ASN1Object {
    private final AlgorithmIdentifier encryptionAlgorithm;
    private final ASN1OctetString encryptedContent;

    public EncryptedObjectStoreData(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.encryptionAlgorithm = algorithmIdentifier;
        this.encryptedContent = new DEROctetString(Arrays.clone(byArray));
    }

    private EncryptedObjectStoreData(ASN1Sequence aSN1Sequence) {
        this.encryptionAlgorithm = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        this.encryptedContent = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(1));
    }

    public static EncryptedObjectStoreData getInstance(Object object) {
        if (object instanceof EncryptedObjectStoreData) {
            return (EncryptedObjectStoreData)object;
        }
        if (object != null) {
            return new EncryptedObjectStoreData(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ASN1OctetString getEncryptedContent() {
        return this.encryptedContent;
    }

    public AlgorithmIdentifier getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.encryptionAlgorithm, this.encryptedContent);
    }
}

