/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.apache.hc.client5.http.impl.auth;

import amp_libs.org.apache.hc.client5.http.auth.AuthScope;
import amp_libs.org.apache.hc.client5.http.auth.Credentials;
import amp_libs.org.apache.hc.client5.http.auth.CredentialsStore;
import amp_libs.org.apache.hc.client5.http.impl.auth.CredentialsMatcher;
import amp_libs.org.apache.hc.core5.annotation.Contract;
import amp_libs.org.apache.hc.core5.annotation.ThreadingBehavior;
import amp_libs.org.apache.hc.core5.http.protocol.HttpContext;
import amp_libs.org.apache.hc.core5.util.Args;
import java.util.concurrent.ConcurrentHashMap;

@Contract(threading=ThreadingBehavior.SAFE)
public class BasicCredentialsProvider
implements CredentialsStore {
    private final ConcurrentHashMap<AuthScope, Credentials> credMap = new ConcurrentHashMap();

    @Override
    public void setCredentials(AuthScope authScope, Credentials credentials) {
        Args.notNull(authScope, "Authentication scope");
        this.credMap.put(authScope, credentials);
    }

    @Override
    public Credentials getCredentials(AuthScope authScope, HttpContext context) {
        return CredentialsMatcher.matchCredentials(this.credMap, authScope);
    }

    @Override
    public void clear() {
        this.credMap.clear();
    }

    public String toString() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.credMap.keySet())).toString();
    }
}

