/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.config.Jsons;
import pl.skidam.automodpack_core.loader.LoaderManagerService;
import pl.skidam.automodpack_core.utils.CustomFileUtils;
import pl.skidam.automodpack_loader_core.ReLauncher;
import pl.skidam.automodpack_loader_core.platforms.ModrinthAPI;
import pl.skidam.automodpack_loader_core.screen.ScreenManager;
import pl.skidam.automodpack_loader_core.utils.DownloadManager;
import pl.skidam.automodpack_loader_core.utils.UpdateType;

public class SelfUpdater {
    public static final String AUTOMODPACK_ID = "k68glP2e";

    public static boolean update() {
        return SelfUpdater.update(null);
    }

    public static boolean update(Jsons.ModpackContentFields serverModpackContent) {
        if (GlobalVariables.LOADER_MANAGER.isDevelopmentEnvironment()) {
            return false;
        }
        if (GlobalVariables.LOADER_MANAGER.getEnvironmentType() == LoaderManagerService.EnvironmentType.SERVER && !GlobalVariables.serverConfig.selfUpdater) {
            GlobalVariables.LOGGER.info("AutoModpack self-updater is disabled in server config.");
            return false;
        }
        List<Object> modrinthAPIList = new ArrayList();
        boolean gettingServerVersion = false;
        if (serverModpackContent != null && serverModpackContent.automodpackVersion != null) {
            modrinthAPIList.add(ModrinthAPI.getModSpecificVersion(AUTOMODPACK_ID, serverModpackContent.automodpackVersion, serverModpackContent.mcVersion));
            gettingServerVersion = true;
        } else {
            modrinthAPIList = ModrinthAPI.getModInfosFromID(AUTOMODPACK_ID);
        }
        if (gettingServerVersion) {
            GlobalVariables.LOGGER.info("Syncing AutoModpack to server version: {}", (Object)serverModpackContent.automodpackVersion);
        } else {
            if (GlobalVariables.LOADER_MANAGER.getEnvironmentType() == LoaderManagerService.EnvironmentType.CLIENT && !GlobalVariables.clientConfig.selfUpdater) {
                GlobalVariables.LOGGER.info("AutoModpack self-updater is disabled in client config.");
                return false;
            }
            GlobalVariables.LOGGER.info("Checking if AutoModpack is up-to-date...");
        }
        Object message = "Couldn't get latest version of AutoModpack from Modrinth API. Likely automodpack isn't updated to your version of minecraft yet...";
        if (modrinthAPIList == null) {
            GlobalVariables.LOGGER.warn((String)message);
            return false;
        }
        for (ModrinthAPI modrinthAPI : modrinthAPIList) {
            if (modrinthAPI == null || modrinthAPI.fileVersion() == null) {
                message = "Couldn't get latest version of AutoModpack from Modrinth API. Likely automodpack isn't updated to your version of minecraft yet...";
                continue;
            }
            String fileVersion = modrinthAPI.fileVersion();
            if (fileVersion.equals(GlobalVariables.AM_VERSION)) {
                message = "Didn't find any updates for AutoModpack!";
                continue;
            }
            boolean currentBeta = GlobalVariables.AM_VERSION.contains("-beta");
            boolean remoteBeta = fileVersion.contains("-beta");
            String[] currentVersionSplit = GlobalVariables.AM_VERSION.split("-beta");
            String[] remoteVersionSplit = fileVersion.split("-beta");
            String OUR_VERSION = currentVersionSplit[0].replace(".", "");
            String LATEST_VERSION = remoteVersionSplit[0].replace(".", "");
            if (!gettingServerVersion) {
                try {
                    if (Integer.parseInt(OUR_VERSION) > Integer.parseInt(LATEST_VERSION)) {
                        message = "You are using pre-released or beta version of AutoModpack: " + GlobalVariables.AM_VERSION + " latest stable version is: " + modrinthAPI.fileVersion();
                        break;
                    }
                }
                catch (NumberFormatException e) {
                    GlobalVariables.LOGGER.error("Failed to parse version numbers: " + String.valueOf(e));
                }
                if (currentBeta && remoteBeta && Integer.parseInt(currentVersionSplit[1]) > Integer.parseInt(remoteVersionSplit[1])) {
                    message = "You are using pre-released or beta version of AutoModpack: " + GlobalVariables.AM_VERSION + " latest stable version is: " + modrinthAPI.fileVersion();
                    break;
                }
                if (!currentBeta && remoteBeta) {
                    message = "You are using stable version of AutoModpack: " + GlobalVariables.AM_VERSION + " latest pre-released or beta version is: " + modrinthAPI.fileVersion();
                    continue;
                }
                if (currentBeta && !remoteBeta) {
                    message = "You are using pre-released or beta version of AutoModpack: " + GlobalVariables.AM_VERSION + " latest stable version is: " + modrinthAPI.fileVersion();
                    continue;
                }
            }
            if (modrinthAPI.SHA1Hash().equals(CustomFileUtils.getHash(GlobalVariables.THIZ_JAR))) {
                message = "Didn't find any updates for AutoModpack! You are on the latest version: " + GlobalVariables.AM_VERSION;
                break;
            }
            GlobalVariables.LOGGER.info("Update found! Updating to the {} version: {}", (Object)(gettingServerVersion ? "server" : "latest"), (Object)modrinthAPI.fileVersion());
            SelfUpdater.installModVersion(modrinthAPI);
            return true;
        }
        GlobalVariables.LOGGER.info((String)message);
        return false;
    }

    public static void installModVersion(ModrinthAPI automodpack) {
        Path automodpackUpdateJar = GlobalVariables.automodpackDir.resolve(automodpack.fileName());
        try {
            DownloadManager downloadManager = new DownloadManager();
            new ScreenManager().download(downloadManager, "AutoModapck " + automodpack.fileVersion());
            downloadManager.download(automodpackUpdateJar, automodpack.SHA1Hash(), List.of(automodpack.downloadUrl()), () -> GlobalVariables.LOGGER.info("Downloaded update for AutoModpack."), () -> GlobalVariables.LOGGER.error("Failed to download update for AutoModpack."));
            downloadManager.joinAll();
            downloadManager.cancelAllAndShutdown();
            SelfUpdater.addOverridesToJar(automodpackUpdateJar);
            Path newAutomodpackJar = GlobalVariables.THIZ_JAR.getParent().resolve(automodpackUpdateJar.getFileName());
            UpdateType updateType = UpdateType.AUTOMODPACK;
            ReLauncher relauncher = new ReLauncher(updateType);
            Runnable callback = () -> {
                CustomFileUtils.executeOrder66(GlobalVariables.THIZ_JAR);
                GlobalVariables.LOGGER.info("Successfully updated AutoModpack!");
            };
            CustomFileUtils.copyFile(automodpackUpdateJar, newAutomodpackJar);
            CustomFileUtils.executeOrder66(automodpackUpdateJar);
            relauncher.restart(true, callback);
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Failed to update! " + String.valueOf(e));
        }
    }

    public static Optional<InputStream> getJarEntryInputStream(Path jarFilePath, String entryName) throws IOException {
        try (JarFile jarFile = new JarFile(jarFilePath.toFile());){
            JarEntry jarEntry = jarFile.getJarEntry(entryName);
            if (jarEntry != null) {
                Optional<InputStream> optional = Optional.of(jarFile.getInputStream(jarEntry));
                return optional;
            }
        }
        return Optional.empty();
    }

    public static void addOverridesToJar(Path jarFilePath) throws IOException {
        if (GlobalVariables.clientConfigOverride == null || GlobalVariables.clientConfigOverride.isBlank()) {
            return;
        }
        if (!Files.isRegularFile(jarFilePath, new LinkOption[0]) || !Files.isRegularFile(GlobalVariables.THIZ_JAR, new LinkOption[0])) {
            GlobalVariables.LOGGER.error("Jar file of updated AutoModpack not found!");
            return;
        }
        Path tempJarPath = Files.createTempFile("tempAutoModpackJar", ".jar", new FileAttribute[0]);
        try (JarFile jarFile = new JarFile(jarFilePath.toFile());
             JarOutputStream tempJarOutputStream = new JarOutputStream(Files.newOutputStream(tempJarPath, new OpenOption[0]));){
            jarFile.stream().forEach(entry -> {
                try {
                    JarEntry newEntry = new JarEntry(entry.getName());
                    tempJarOutputStream.putNextEntry(newEntry);
                    try (InputStream entryInputStream = jarFile.getInputStream((ZipEntry)entry);){
                        entryInputStream.transferTo(tempJarOutputStream);
                    }
                    tempJarOutputStream.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            Optional<InputStream> txtInputStreamOpt = SelfUpdater.getJarEntryInputStream(GlobalVariables.THIZ_JAR, "overrides-automodpack-client.json");
            if (txtInputStreamOpt.isPresent()) {
                JarEntry newTxtEntry = new JarEntry("overrides-automodpack-client.json");
                tempJarOutputStream.putNextEntry(newTxtEntry);
                txtInputStreamOpt.get().transferTo(tempJarOutputStream);
                tempJarOutputStream.closeEntry();
            }
        }
        Files.move(tempJarPath, jarFilePath, StandardCopyOption.REPLACE_EXISTING);
        GlobalVariables.LOGGER.info("Added config overrides to the updated AutoModpack JAR");
    }
}

