/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.apache.hc.client5.http.impl.cookie;

import amp_libs.org.apache.hc.client5.http.cookie.CommonCookieAttributeHandler;
import amp_libs.org.apache.hc.client5.http.cookie.Cookie;
import amp_libs.org.apache.hc.client5.http.cookie.CookieOrigin;
import amp_libs.org.apache.hc.client5.http.cookie.MalformedCookieException;
import amp_libs.org.apache.hc.client5.http.cookie.SetCookie;
import amp_libs.org.apache.hc.client5.http.impl.cookie.AbstractCookieAttributeHandler;
import amp_libs.org.apache.hc.core5.annotation.Contract;
import amp_libs.org.apache.hc.core5.annotation.ThreadingBehavior;
import amp_libs.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    public static final BasicSecureHandler INSTANCE = new BasicSecureHandler();

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

