/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.asn1.x509;

import amp_libs.org.bouncycastle.asn1.ASN1Object;
import amp_libs.org.bouncycastle.asn1.ASN1OctetString;
import amp_libs.org.bouncycastle.asn1.ASN1Primitive;
import amp_libs.org.bouncycastle.asn1.ASN1Sequence;
import amp_libs.org.bouncycastle.asn1.ASN1TaggedObject;
import amp_libs.org.bouncycastle.asn1.DEROctetString;
import amp_libs.org.bouncycastle.asn1.DERSequence;
import amp_libs.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import amp_libs.org.bouncycastle.util.Arrays;
import java.util.Enumeration;

public class DigestInfo
extends ASN1Object {
    private byte[] digest;
    private AlgorithmIdentifier algId;

    public static DigestInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DigestInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static DigestInfo getInstance(Object object) {
        if (object instanceof DigestInfo) {
            return (DigestInfo)object;
        }
        if (object != null) {
            return new DigestInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public DigestInfo(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.digest = Arrays.clone(byArray);
        this.algId = algorithmIdentifier;
    }

    public DigestInfo(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.algId = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        this.digest = ASN1OctetString.getInstance(enumeration.nextElement()).getOctets();
    }

    public AlgorithmIdentifier getAlgorithmId() {
        return this.algId;
    }

    public byte[] getDigest() {
        return Arrays.clone(this.digest);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.algId, new DEROctetString(this.digest));
    }
}

