/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.utils.Json;

public class MmcPackMagic {
    public static final Path mmcPackFile = Paths.get("./../mmc-pack.json", new String[0]);
    public static final List<String> MINECRAFT_UID = Arrays.asList("net.minecraft", "net.fabricmc.intermediary");
    public static final List<String> FABRIC_LOADER_UID = List.of("net.fabricmc.fabric-loader");
    public static final List<String> QUILT_LOADER_UID = List.of("org.quiltmc.quilt-loader");
    public static final List<String> FORGE_LOADER_UID = List.of("net.minecraftforge");
    public static final List<String> NEOFORGE_LOADER_UID = List.of("net.neoforged");

    public static JsonObject getJson() throws IOException {
        return Json.fromFile(mmcPackFile);
    }

    public static void changeVersion(List<String> UID, String newVersion) throws IOException {
        if (newVersion == null || UID == null) {
            return;
        }
        if (!Files.exists(mmcPackFile, new LinkOption[0])) {
            return;
        }
        JsonObject newJson = MmcPackMagic.getJson().getAsJsonObject();
        if (newJson == null) {
            return;
        }
        JsonArray components = newJson.getAsJsonArray("components");
        for (JsonElement comp : components) {
            JsonObject component = comp.getAsJsonObject();
            if (!UID.contains(component.get("uid").getAsString())) continue;
            String oldVersion = component.get("version").getAsString();
            component.remove("version");
            component.addProperty("version", newVersion);
            if (oldVersion.equals(newVersion)) continue;
            GlobalVariables.LOGGER.info("Changed version of " + component.get("uid").getAsString() + " to " + newVersion);
        }
        newJson.remove("components");
        newJson.add("components", (JsonElement)components);
        Files.write(mmcPackFile, newJson.toString().getBytes(), new OpenOption[0]);
    }
}

