/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.config;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.config.ConfigTools;
import pl.skidam.automodpack_core.utils.CustomFileUtils;

public class ConfigUtils {
    public static void normalizeServerConfig(boolean saveAfter) {
        ConfigUtils.normalizeServerConfig();
        if (saveAfter) {
            ConfigTools.save(GlobalVariables.serverConfigFile, GlobalVariables.serverConfig);
        }
    }

    public static void normalizeServerConfig() {
        String fixed;
        Matcher matcher;
        ArrayList<String> fixedSyncedFiles = new ArrayList<String>(GlobalVariables.serverConfig.syncedFiles.size());
        ArrayList<String> fixedAllowEditsInFiles = new ArrayList<String>(GlobalVariables.serverConfig.allowEditsInFiles.size());
        ArrayList<String> fixedForceCopyFilesToStandardLocation = new ArrayList<String>(GlobalVariables.serverConfig.forceCopyFilesToStandardLocation.size());
        String prefixPattern = "^/automodpack/host-modpack/[^/]+/";
        Pattern pattern = Pattern.compile(prefixPattern);
        for (String file : GlobalVariables.serverConfig.syncedFiles) {
            if (pattern.matcher(file).find()) {
                GlobalVariables.LOGGER.info("Removed redundant syncedFiles entry '{}': paths under '/automodpack/host-modpack/' are implicitly synced.", (Object)file);
                continue;
            }
            fixedSyncedFiles.add(CustomFileUtils.prefixSlash(file));
        }
        for (String file : GlobalVariables.serverConfig.allowEditsInFiles) {
            matcher = pattern.matcher(file);
            fixed = file;
            if (matcher.find()) {
                fixed = matcher.replaceFirst("");
                GlobalVariables.LOGGER.info("Normalized allowEditsInFiles entry: '{}' -> '{}'. Removed '/automodpack/host-modpack/' prefix.", (Object)file, (Object)fixed);
            }
            fixedAllowEditsInFiles.add(CustomFileUtils.prefixSlash(fixed));
        }
        for (String file : GlobalVariables.serverConfig.forceCopyFilesToStandardLocation) {
            matcher = pattern.matcher(file);
            fixed = file;
            if (matcher.find()) {
                fixed = matcher.replaceFirst("");
                GlobalVariables.LOGGER.info("Normalized forceCopyFilesToStandardLocation entry: '{}' -> '{}'. Removed '/automodpack/host-modpack/' prefix.", (Object)file, (Object)fixed);
            }
            fixedForceCopyFilesToStandardLocation.add(CustomFileUtils.prefixSlash(fixed));
        }
        GlobalVariables.serverConfig.syncedFiles = fixedSyncedFiles;
        GlobalVariables.serverConfig.allowEditsInFiles = fixedAllowEditsInFiles;
        GlobalVariables.serverConfig.forceCopyFilesToStandardLocation = fixedForceCopyFilesToStandardLocation;
    }
}

