/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.protocol.compression;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import pl.skidam.automodpack_core.protocol.compression.CompressionCodec;

public class GzipCompression
implements CompressionCodec {
    @Override
    public boolean isInitialized() {
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] compress(byte[] input) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
                gzipOutputStream.write(input);
                gzipOutputStream.finish();
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
        catch (Exception e) {
            throw new IOException("Failed to compress data with GZIP", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] decompress(byte[] compressed, int originalLength) throws IOException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(compressed);){
            byte[] byArray;
            try (GZIPInputStream gzipInputStream = new GZIPInputStream(byteArrayInputStream);){
                int totalRead;
                int bytesRead;
                byte[] decompressed = new byte[originalLength];
                for (totalRead = 0; totalRead < originalLength && (bytesRead = gzipInputStream.read(decompressed, totalRead, originalLength - totalRead)) != -1; totalRead += bytesRead) {
                }
                if (totalRead != originalLength) {
                    throw new IOException("Decompressed length (" + totalRead + ") does not match expected length (" + originalLength + ")");
                }
                byArray = decompressed;
            }
            return byArray;
        }
        catch (Exception e) {
            throw new IOException("Failed to decompress data with GZIP", e);
        }
    }

    @Override
    public byte getCompressionType() {
        return 2;
    }
}

