/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import pl.skidam.automodpack_core.GlobalVariables;

public class WildCards {
    private final Map<String, Path> wildcardMatches = new HashMap<String, Path>();
    private final Map<String, Path> wildcardBlackListed = new HashMap<String, Path>();

    public WildCards(List<String> wildcardsList, Set<Path> directoriesToSearch) {
        if (directoriesToSearch.isEmpty()) {
            return;
        }
        wildcardsList = new ArrayList<String>(wildcardsList);
        wildcardsList.sort(Comparator.comparing(s2 -> s2.startsWith("!")));
        for (String wildcard : wildcardsList) {
            boolean blackListed = wildcard.startsWith("!");
            wildcard = blackListed ? wildcard.replaceFirst("!", "") : wildcard;
            String wildcardPathStr = wildcard.replace(File.separator, "/");
            if (wildcard.contains("/")) {
                wildcardPathStr = wildcard.lastIndexOf(47) == 0 ? (wildcard = wildcard.replace("/", "")) : wildcard.substring(0, wildcard.lastIndexOf(47));
            }
            if (wildcardPathStr.contains("*")) {
                GlobalVariables.LOGGER.warn("Wildcard: \"{}\" contains '*' in a directory, which is not supported. Wildcards only works with filenames not directories.", (Object)wildcard);
                continue;
            }
            wildcardPathStr = wildcardPathStr.replace("/", File.separator);
            for (Path pathToSearch : directoriesToSearch) {
                boolean startsWithSlash;
                Path wildcardPath = Path.of(wildcardPathStr, new String[0]);
                if (!Files.exists(wildcardPath, new LinkOption[0])) {
                    startsWithSlash = wildcardPathStr.charAt(0) == File.separatorChar;
                    wildcardPathStr = startsWithSlash ? wildcardPathStr.replaceFirst(Matcher.quoteReplacement(File.separator), "") : wildcardPathStr;
                    wildcardPath = Path.of(wildcardPathStr, new String[0]);
                } else {
                    startsWithSlash = false;
                }
                Path path = !wildcardPath.startsWith(pathToSearch) ? pathToSearch.resolve(wildcardPath) : wildcardPath;
                wildcardPathStr = wildcardPathStr.replace(File.separator, "/");
                if (GlobalVariables.DEBUG.booleanValue()) {
                    System.out.println("Path: " + String.valueOf(path) + " wildcard: " + wildcard + " startsWithSlash: " + startsWithSlash + " blackListed: " + blackListed);
                }
                if (Files.isDirectory(path, new LinkOption[0])) {
                    try (Stream<Path> files = Files.list(path);){
                        String finalWildcardPathStr = wildcardPathStr;
                        String finalWildcard = wildcard;
                        files.forEach(childPath -> this.processFile((Path)childPath, finalWildcardPathStr, finalWildcard, startsWithSlash, blackListed));
                    }
                    catch (IOException e) {
                        GlobalVariables.LOGGER.error("Error occurred while processing directory for wildcard: {} path: {}", (Object)wildcard, (Object)path, (Object)e);
                    }
                    continue;
                }
                this.processFile(path, wildcardPathStr, wildcard, startsWithSlash, blackListed);
            }
        }
    }

    private void processFile(Path file, String pathStr, String finalWildcard, boolean startsWithSlash, boolean blackListed) {
        if (Files.isDirectory(file, new LinkOption[0])) {
            try (Stream<Path> files = Files.list(file);){
                String finalPathStr = pathStr;
                files.forEach(childPath -> this.processFile((Path)childPath, finalPathStr, finalWildcard, startsWithSlash, blackListed));
            }
            catch (IOException e) {
                GlobalVariables.LOGGER.error("Error occurred while processing directory for wildcard: {} path: {}", (Object)finalWildcard, (Object)file, (Object)e);
            }
        } else {
            String formattedPath = file.toString().replace(File.separator, "/");
            int index = formattedPath.indexOf((String)pathStr);
            if (index != -1) {
                pathStr = (String)pathStr + file.toString().substring(index + ((String)pathStr).length());
                pathStr = ((String)(pathStr = ((String)pathStr).replace(File.separator, "/"))).startsWith("/") ? pathStr : "/" + (String)pathStr;
                this.matchFile(file, (String)pathStr, finalWildcard, startsWithSlash, blackListed);
            } else if (finalWildcard.contains("**")) {
                this.matchFile(file, formattedPath, finalWildcard, startsWithSlash, blackListed);
            } else {
                throw new IllegalStateException("FormattedPath: " + formattedPath + " PathStr: " + (String)pathStr + " Does not match the wildcard: " + finalWildcard + " StartsWithSlash: " + startsWithSlash + " IsBlackListed: " + blackListed);
            }
        }
    }

    private void matchFile(Path path, String formattedPath, String finalWildcard, boolean startsWithSlash, boolean blackListed) {
        Object matchFileStr;
        String formatedPath = path.toString().replace(File.separator, "/");
        Object object = matchFileStr = startsWithSlash ? "/" + formatedPath : formatedPath;
        if (this.fileMatches((String)matchFileStr, finalWildcard)) {
            if (blackListed) {
                this.wildcardMatches.remove(formattedPath, path);
                this.wildcardBlackListed.put(formattedPath, path);
                if (GlobalVariables.DEBUG.booleanValue()) {
                    System.out.println("File " + formattedPath + " is excluded! Skipping...");
                }
            } else if (!this.wildcardMatches.containsKey(formattedPath)) {
                this.wildcardMatches.put(formattedPath, path);
                if (GlobalVariables.DEBUG.booleanValue()) {
                    System.out.println("File " + formattedPath + " matches!");
                }
            }
        }
    }

    private boolean fileMatches(String file, String wildCardString) {
        if (!wildCardString.contains("*")) {
            if (GlobalVariables.DEBUG.booleanValue()) {
                System.out.println("* NOT found in wildcard: " + wildCardString + " file: " + file);
            }
            return file.endsWith(wildCardString);
        }
        if (wildCardString.contains("**")) {
            String[] parts;
            if (GlobalVariables.DEBUG.booleanValue()) {
                System.out.println("** found in wildcard: " + wildCardString + " file: " + file);
            }
            if ((parts = wildCardString.split("\\*\\*")).length == 0) {
                return true;
            }
            int startIndex = 0;
            for (String part : parts) {
                int currentIndex = file.indexOf(part, startIndex);
                if (currentIndex == -1) {
                    return false;
                }
                startIndex = currentIndex + part.length();
            }
            return true;
        }
        if (GlobalVariables.DEBUG.booleanValue()) {
            System.out.println("* found in wildcard: " + wildCardString + " file: " + file);
        }
        String[] excludeFileParts = wildCardString.split("\\*");
        int startIndex = 0;
        for (String excludeFilePart : excludeFileParts) {
            int currentIndex = file.indexOf(excludeFilePart, startIndex);
            if (currentIndex == -1) {
                return false;
            }
            startIndex = currentIndex + excludeFilePart.length();
        }
        return true;
    }

    public boolean fileMatches(String path, Path file) {
        return this.wildcardMatches.containsKey(path) || this.wildcardMatches.containsValue(file);
    }

    public Map<String, Path> getWildcardMatches() {
        return this.wildcardMatches;
    }

    public boolean fileBlackListed(String path, Path file) {
        return this.wildcardBlackListed.containsKey(path) || this.wildcardBlackListed.containsValue(file);
    }

    public Map<String, Path> getWildcardBlackListed() {
        return this.wildcardBlackListed;
    }
}

