/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.apache.hc.client5.http.impl.async;

import amp_libs.org.apache.hc.client5.http.HttpRoute;
import amp_libs.org.apache.hc.client5.http.async.AsyncExecRuntime;
import amp_libs.org.apache.hc.client5.http.auth.AuthSchemeFactory;
import amp_libs.org.apache.hc.client5.http.auth.CredentialsProvider;
import amp_libs.org.apache.hc.client5.http.config.RequestConfig;
import amp_libs.org.apache.hc.client5.http.cookie.CookieSpecFactory;
import amp_libs.org.apache.hc.client5.http.cookie.CookieStore;
import amp_libs.org.apache.hc.client5.http.impl.async.AsyncExecChainElement;
import amp_libs.org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import amp_libs.org.apache.hc.client5.http.impl.async.InternalAbstractHttpAsyncClient;
import amp_libs.org.apache.hc.client5.http.impl.async.InternalH2AsyncExecRuntime;
import amp_libs.org.apache.hc.client5.http.impl.async.InternalH2ConnPool;
import amp_libs.org.apache.hc.client5.http.protocol.HttpClientContext;
import amp_libs.org.apache.hc.client5.http.routing.HttpRoutePlanner;
import amp_libs.org.apache.hc.core5.annotation.Contract;
import amp_libs.org.apache.hc.core5.annotation.Internal;
import amp_libs.org.apache.hc.core5.annotation.ThreadingBehavior;
import amp_libs.org.apache.hc.core5.http.HttpException;
import amp_libs.org.apache.hc.core5.http.HttpHost;
import amp_libs.org.apache.hc.core5.http.HttpRequest;
import amp_libs.org.apache.hc.core5.http.config.Lookup;
import amp_libs.org.apache.hc.core5.http.nio.AsyncPushConsumer;
import amp_libs.org.apache.hc.core5.http.nio.HandlerFactory;
import amp_libs.org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import amp_libs.org.slf4j.Logger;
import amp_libs.org.slf4j.LoggerFactory;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.ThreadFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
@Internal
public final class InternalH2AsyncClient
extends InternalAbstractHttpAsyncClient {
    private static final Logger LOG = LoggerFactory.getLogger(InternalH2AsyncClient.class);
    private final HttpRoutePlanner routePlanner;
    private final InternalH2ConnPool connPool;

    InternalH2AsyncClient(DefaultConnectingIOReactor ioReactor, AsyncExecChainElement execChain, AsyncPushConsumerRegistry pushConsumerRegistry, ThreadFactory threadFactory, InternalH2ConnPool connPool, HttpRoutePlanner routePlanner, Lookup<CookieSpecFactory> cookieSpecRegistry, Lookup<AuthSchemeFactory> authSchemeRegistry, CookieStore cookieStore, CredentialsProvider credentialsProvider, RequestConfig defaultConfig, List<Closeable> closeables) {
        super(ioReactor, pushConsumerRegistry, threadFactory, execChain, cookieSpecRegistry, authSchemeRegistry, cookieStore, credentialsProvider, HttpClientContext::castOrCreate, defaultConfig, closeables);
        this.connPool = connPool;
        this.routePlanner = routePlanner;
    }

    @Override
    AsyncExecRuntime createAsyncExecRuntime(HandlerFactory<AsyncPushConsumer> pushHandlerFactory) {
        return new InternalH2AsyncExecRuntime(LOG, this.connPool, pushHandlerFactory);
    }

    @Override
    HttpRoute determineRoute(HttpHost httpHost, HttpRequest request, HttpClientContext clientContext) throws HttpException {
        HttpRoute route = this.routePlanner.determineRoute(httpHost, request, clientContext);
        if (route.isTunnelled()) {
            throw new HttpException("HTTP/2 tunneling not supported");
        }
        return route;
    }
}

