/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.math.ec.endo;

import amp_libs.org.bouncycastle.math.ec.ECCurve;
import amp_libs.org.bouncycastle.math.ec.ECPointMap;
import amp_libs.org.bouncycastle.math.ec.ScaleXPointMap;
import amp_libs.org.bouncycastle.math.ec.endo.EndoUtil;
import amp_libs.org.bouncycastle.math.ec.endo.GLVEndomorphism;
import amp_libs.org.bouncycastle.math.ec.endo.GLVTypeBParameters;
import java.math.BigInteger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class GLVTypeBEndomorphism
implements GLVEndomorphism {
    protected final GLVTypeBParameters parameters;
    protected final ECPointMap pointMap;

    public GLVTypeBEndomorphism(ECCurve eCCurve, GLVTypeBParameters gLVTypeBParameters) {
        this.parameters = gLVTypeBParameters;
        this.pointMap = new ScaleXPointMap(eCCurve.fromBigInteger(gLVTypeBParameters.getBeta()));
    }

    @Override
    public BigInteger[] decomposeScalar(BigInteger bigInteger) {
        return EndoUtil.decomposeScalar(this.parameters.getSplitParams(), bigInteger);
    }

    @Override
    public ECPointMap getPointMap() {
        return this.pointMap;
    }

    @Override
    public boolean hasEfficientPointMap() {
        return true;
    }
}

