/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.utils.CustomFileUtils;

public class WildCards {
    private final Map<String, Path> wildcardMatches = new HashMap<String, Path>();
    private final List<String> RULES;
    private final Set<Path> START_DIRECTORIES;
    private static final Map<Path, Set<Path>> discoveredDirectoriesCache = new HashMap<Path, Set<Path>>();
    private static final Map<Path, String> formattedPathCache = new HashMap<Path, String>();
    private static final Map<String, String[]> pathComponentsCache = new HashMap<String, String[]>();
    private final List<ParsedRule> whiteListRules = new ArrayList<ParsedRule>();
    private final List<ParsedRule> blackListRules = new ArrayList<ParsedRule>();

    public boolean fileMatches(String path, Path file) {
        return this.wildcardMatches.containsKey(path) || this.wildcardMatches.containsValue(file);
    }

    public Map<String, Path> getWildcardMatches() {
        return this.wildcardMatches;
    }

    public WildCards(List<String> rules, Set<Path> startDirectories) {
        this.RULES = rules;
        this.START_DIRECTORIES = startDirectories;
    }

    public static void clearCache() {
        discoveredDirectoriesCache.clear();
        formattedPathCache.clear();
        pathComponentsCache.clear();
    }

    public void match(boolean clearCache) {
        this.innerMatch();
        if (clearCache) {
            WildCards.clearCache();
        }
    }

    public void match() {
        this.match(true);
    }

    private void innerMatch() {
        try {
            if (this.RULES == null || this.RULES.isEmpty()) {
                return;
            }
            this.parseRules(this.RULES);
            for (Path startDirectory : this.START_DIRECTORIES) {
                Set alreadyDiscovered = discoveredDirectoriesCache.getOrDefault(startDirectory, Set.of());
                if (!alreadyDiscovered.isEmpty()) {
                    for (Path node : alreadyDiscovered) {
                        try {
                            if (!Files.isRegularFile(node, new LinkOption[0])) continue;
                            this.matchWhiteRules(node, startDirectory);
                        }
                        catch (Exception e) {
                            GlobalVariables.LOGGER.error("Error processing file: {} From already discovered directory: {}", (Object)node, (Object)startDirectory, (Object)e);
                        }
                    }
                } else {
                    this.smartWalk(startDirectory);
                }
                this.matchBlackRules();
            }
        }
        catch (Exception e) {
            GlobalVariables.LOGGER.error("Failed to walk directories: {}", this.START_DIRECTORIES, (Object)e);
        }
    }

    private void parseRules(List<String> rules) {
        for (String rule : rules) {
            if (rule == null || rule.isBlank()) continue;
            boolean isBlacklist = rule.startsWith("!");
            String cleanRule = isBlacklist ? rule.substring(1) : rule;
            boolean isRecursive = cleanRule.endsWith("/**");
            if (isRecursive) {
                cleanRule = cleanRule.substring(0, cleanRule.length() - 3);
            }
            String[] components = this.splitPathIntoComponents(cleanRule);
            ParsedRule parsedRule = new ParsedRule(rule, components, isRecursive);
            if (isBlacklist) {
                this.blackListRules.add(parsedRule);
                continue;
            }
            this.whiteListRules.add(parsedRule);
        }
    }

    private void smartWalk(Path startDirectory) {
        HashSet<Path> discoveredFiles = new HashSet<Path>();
        this.smartWalkRecursive(startDirectory, startDirectory, new String[0], discoveredFiles);
        discoveredDirectoriesCache.put(startDirectory, discoveredFiles);
    }

    private void smartWalkRecursive(Path current, Path startDirectory, String[] currentComponents, Set<Path> discoveredFiles) {
        if (!this.couldMatchAnyRule(currentComponents)) {
            return;
        }
        try (Stream<Path> entries = Files.list(current);){
            entries.forEach(entry -> {
                String entryName = entry.getFileName().toString();
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    String[] newComponents = Arrays.copyOf(currentComponents, currentComponents.length + 1);
                    newComponents[currentComponents.length] = entryName;
                    this.smartWalkRecursive((Path)entry, startDirectory, newComponents, discoveredFiles);
                } else if (Files.isRegularFile(entry, new LinkOption[0])) {
                    discoveredFiles.add((Path)entry);
                    this.matchWhiteRules((Path)entry, startDirectory);
                }
            });
        }
        catch (IOException e) {
            GlobalVariables.LOGGER.error("Error listing directory: {}", (Object)current, (Object)e);
        }
    }

    private boolean couldMatchAnyRule(String[] dirComponents) {
        if (dirComponents.length == 0) {
            return true;
        }
        for (ParsedRule rule : this.whiteListRules) {
            if (!this.couldMatchRule(dirComponents, rule)) continue;
            return true;
        }
        return false;
    }

    private boolean couldMatchRule(String[] dirComponents, ParsedRule rule) {
        if (rule.maxDepth != -1 && dirComponents.length >= rule.maxDepth) {
            return false;
        }
        int checkDepth = Math.min(dirComponents.length, rule.components.length - 1);
        for (int i = 0; i < checkDepth; ++i) {
            if (this.matchComponent(dirComponents[i], rule.components[i])) continue;
            return false;
        }
        return true;
    }

    private void matchWhiteRules(Path node, Path startDirectory) {
        String formattedPath = this.getFormattedPath(node, startDirectory);
        if (formattedPath == null) {
            return;
        }
        String[] pathComponents = this.splitPathIntoComponents(formattedPath);
        for (ParsedRule rule : this.whiteListRules) {
            if (!this.matchesRule(pathComponents, rule)) continue;
            this.wildcardMatches.put(formattedPath, node);
            break;
        }
    }

    private void matchBlackRules() {
        HashSet<String> pathsToRemove = new HashSet<String>();
        block0: for (Map.Entry<String, Path> entry : new HashMap<String, Path>(this.wildcardMatches).entrySet()) {
            String formattedPath = entry.getKey();
            String[] pathComponents = this.splitPathIntoComponents(formattedPath);
            for (ParsedRule rule : this.blackListRules) {
                if (!this.matchesRule(pathComponents, rule)) continue;
                pathsToRemove.add(formattedPath);
                continue block0;
            }
        }
        for (String path : pathsToRemove) {
            this.wildcardMatches.remove(path);
        }
    }

    private String getFormattedPath(Path node, Path startDirectory) {
        return formattedPathCache.computeIfAbsent(node, n -> CustomFileUtils.formatPath(n, startDirectory));
    }

    private String[] splitPathIntoComponents(String formattedPath) {
        return pathComponentsCache.computeIfAbsent(formattedPath, path -> {
            String[] components = path.split("/");
            ArrayList<String> componentList = new ArrayList<String>();
            for (String comp : components) {
                if (comp.isEmpty()) continue;
                componentList.add(comp);
            }
            return componentList.toArray(new String[0]);
        });
    }

    private boolean matchesRule(String[] pathComponents, ParsedRule rule) {
        String[] ruleComponents = rule.components;
        if (rule.isRecursive) {
            if (pathComponents.length < ruleComponents.length) {
                return false;
            }
            for (int i = 0; i < ruleComponents.length; ++i) {
                if (this.matchComponent(pathComponents[i], ruleComponents[i])) continue;
                return false;
            }
            return true;
        }
        if (pathComponents.length != ruleComponents.length) {
            return false;
        }
        for (int i = 0; i < ruleComponents.length; ++i) {
            if (this.matchComponent(pathComponents[i], ruleComponents[i])) continue;
            return false;
        }
        return true;
    }

    private boolean matchComponent(String pathComponent, String ruleComponent) {
        if (pathComponent.equals(ruleComponent)) {
            return true;
        }
        if (!ruleComponent.contains("*")) {
            return false;
        }
        if (ruleComponent.equals("*")) {
            return true;
        }
        String[] segments = ruleComponent.split("\\*", -1);
        int pos = 0;
        for (int i = 0; i < segments.length; ++i) {
            String segment = segments[i];
            if (i == 0) {
                if (!pathComponent.startsWith(segment)) {
                    return false;
                }
                pos = segment.length();
                continue;
            }
            if (i == segments.length - 1) {
                if (!pathComponent.endsWith(segment)) {
                    return false;
                }
                if (pos <= pathComponent.length() - segment.length()) continue;
                return false;
            }
            int index = pathComponent.indexOf(segment, pos);
            if (index == -1) {
                return false;
            }
            pos = index + segment.length();
        }
        return true;
    }

    private record ParsedRule(String originalRule, String[] components, boolean isRecursive, int minDepth, int maxDepth) {
        ParsedRule(String originalRule, String[] components, boolean isRecursive) {
            this(originalRule, components, isRecursive, components.length, isRecursive ? -1 : components.length);
        }
    }
}

