/*
 * Decompiled with CFR 0.152.
 */
package am_libs.org.apache.hc.client5.http.protocol;

import am_libs.org.apache.hc.core5.annotation.Contract;
import am_libs.org.apache.hc.core5.annotation.ThreadingBehavior;
import am_libs.org.apache.hc.core5.http.EntityDetails;
import am_libs.org.apache.hc.core5.http.Header;
import am_libs.org.apache.hc.core5.http.HttpException;
import am_libs.org.apache.hc.core5.http.HttpRequest;
import am_libs.org.apache.hc.core5.http.HttpRequestInterceptor;
import am_libs.org.apache.hc.core5.http.Method;
import am_libs.org.apache.hc.core5.http.protocol.HttpContext;
import am_libs.org.apache.hc.core5.util.Args;
import java.io.IOException;
import java.util.Collection;

@Contract(threading=ThreadingBehavior.STATELESS)
public class RequestDefaultHeaders
implements HttpRequestInterceptor {
    public static final RequestDefaultHeaders INSTANCE = new RequestDefaultHeaders();
    private final Collection<? extends Header> defaultHeaders;

    public RequestDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public RequestDefaultHeaders() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getMethod();
        if (Method.CONNECT.isSame(method)) {
            return;
        }
        if (this.defaultHeaders != null) {
            for (Header header : this.defaultHeaders) {
                if (request.containsHeader(header.getName())) continue;
                request.addHeader(header);
            }
        }
    }
}

